/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.MegaBraceletItem;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class MegaLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public static boolean Possible(ServerPlayer player, boolean fromBattle) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId) && !fromBattle) {
            player.displayClientMessage((Component)Component.literal((String)"Not so fast!").withColor(0xFF0000), true);
            return false;
        }
        boolean hasMegaItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.getItem() instanceof MegaBraceletItem)).orElse(false);
        boolean hasOffhandMegaItem = player.getOffhandItem().getItem() instanceof MegaBraceletItem;
        boolean hasMainhandMegaItem = player.getMainHandItem().getItem() instanceof MegaBraceletItem;
        if (!(hasMegaItemCurios || hasOffhandMegaItem || hasMainhandMegaItem)) {
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void EvoLogic(Player playerContext) {
        ServerPlayer player = (ServerPlayer)playerContext;
        if (Config.battleModeOnly) {
            return;
        }
        double range = 5.0;
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = startPos.add(lookVec.multiply(range, range, range));
        AABB searchBox = new AABB(startPos, endPos).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)searchBox, entity -> !entity.isSpectator() && entity.isPickable(), (float)0.3f);
        if (entityHit == null) {
            return;
        }
        Entity entity2 = entityHit.getEntity();
        if (entity2 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity2;
            if (pk.level().isClientSide) {
                return;
            }
            if (pk.getPokemon().getOwnerPlayer() != player || !MegaLogic.Possible(player, false)) {
                return;
            }
            List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
            boolean end = false;
            for (String key : megaKeys) {
                FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                FlagSpeciesFeature feature = featureProvider.get(pk.getPokemon());
                if (feature == null) continue;
                boolean enabled = featureProvider.get(pk.getPokemon()).getEnabled();
                if (enabled) {
                    MegaLogic.Devolve((LivingEntity)pk, (Player)player, false);
                    end = false;
                    break;
                }
                end = true;
            }
            if (end) {
                MegaLogic.Evolve((LivingEntity)pk, (Player)player, false);
            }
        }
    }

    public static void Evolve(LivingEntity context, Player player, Boolean fromBattle) {
        PokemonEntity pk;
        PokemonEntity pk2;
        if (context instanceof PokemonEntity && (pk2 = (PokemonEntity)context).getPokemon().getOwnerPlayer() != player) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)context).getPokemon();
        Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (context instanceof PokemonEntity && (pk = (PokemonEntity)context).isBattling() && !fromBattle.booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"Not allowed in battle").withColor(0xFF0000), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            if (Config.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.displayClientMessage((Component)Component.literal((String)"You are not close enough with your pokemon to mega outside").withColor(0xFF0000), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                player.setData(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.playEvolveAnimation(context);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                found = true;
            }
            if (!found) {
                player.displayClientMessage((Component)Component.literal((String)"Rayquaza doesn't have dragonascent").withColor(0xFF0000), true);
            }
            return;
        }
        if (pokemon.getSpecies().getName().equals(Utils.getSpecies("rayquaza").getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
            return;
        }
        if (species == null) {
            player.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
            return;
        }
        if (Config.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.displayClientMessage((Component)Component.literal((String)"You are not close enough with your pokemon to mega outside").withColor(0xFF0000), true);
            return;
        }
        if (species.getName().equals(pokemon.getSpecies().getName()) && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            if (species.getName().equals(Utils.getSpecies("charizard").getName())) {
                if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                } else if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                }
            } else if (species.getName().equals(Utils.getSpecies("mewtwo").getName())) {
                if (pokemon.heldItem().is(MegaStones.MEWTWONITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                } else if (pokemon.heldItem().is(MegaStones.MEWTWONITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                    MegaLogic.playEvolveAnimation(context);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", true).apply(pokemon);
                    Utils.setTradable(pokemon, false);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
                }
            } else {
                player.setData(DataManage.MEGA_DATA, (Object)true);
                player.setData(DataManage.MEGA_POKEMON, (Object)pokemon);
                new FlagSpeciesFeature("mega", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
                MegaLogic.playEvolveAnimation(context);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "mega_evolve");
            }
        } else if (species.getName().equals(pokemon.getSpecies().getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)"You can only have one mega at a time").withColor(0xFF0000), true);
        } else {
            player.displayClientMessage((Component)Component.literal((String)"Don't have the correct stone").withColor(0xFF0000), true);
        }
    }

    public static void Devolve(LivingEntity context, Player player, Boolean fromBattle) {
        if (player.level().isClientSide || context == null) {
            return;
        }
        if (context instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)context;
            if (pk.getPokemon().getOwnerPlayer() != player) {
                return;
            }
            if (pk.isBattling() && !fromBattle.booleanValue()) {
                player.displayClientMessage((Component)Component.literal((String)"Not allowed in battle").withColor(0xFF0000), true);
                return;
            }
            Pokemon pokemon = ((PokemonEntity)context).getPokemon();
            player.setData(DataManage.MEGA_DATA, (Object)false);
            player.setData(DataManage.MEGA_POKEMON, (Object)new Pokemon());
            MegaLogic.playDevolveAnimation(context);
            new FlagSpeciesFeature("mega", false).apply(pokemon);
            new FlagSpeciesFeature("mega-x", false).apply(pokemon);
            new FlagSpeciesFeature("mega-y", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
        }
    }

    public static void playEvolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void playDevolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_DEACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

