/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.github.yajatkaul.mega_showdown.utils.AccessoriesUtils;
import com.github.yajatkaul.mega_showdown.utils.AspectUtils;
import com.github.yajatkaul.mega_showdown.utils.RegistryLocator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public record MegaGimmick(String showdown_id, List<String> pokemons, AspectSetCodec aspect_conditions) {
    public static final Codec<MegaGimmick> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("showdown_id").forGetter(MegaGimmick::showdown_id), (App)Codec.list((Codec)Codec.STRING).fieldOf("pokemons").forGetter(MegaGimmick::pokemons), (App)AspectSetCodec.CODEC.fieldOf("aspect").forGetter(MegaGimmick::aspect_conditions)).apply((Applicative)instance, MegaGimmick::new));
    private static final Set<String> mega_aspects = new HashSet<String>(Set.of("mega", "mega_y", "mega_x"));

    public static void appendMegaAspect(String aspect) {
        mega_aspects.add(aspect);
    }

    public static Set<String> getMegaAspects() {
        return mega_aspects;
    }

    public static boolean hasMega(class_3222 player) {
        if (MegaShowdownConfig.multipleMegas) {
            return false;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        PCStore pcStore = Cobblemon.INSTANCE.getStorage().getPC(player);
        for (Pokemon pokemon : playerPartyStore) {
            if (!pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) continue;
            return true;
        }
        for (Pokemon pokemon : pcStore) {
            if (!pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) continue;
            return true;
        }
        return false;
    }

    public static void megaEvolveInBattle(Pokemon pokemon, BattlePokemon battlePokemon) {
        class_1799 heldItem = pokemon.heldItem();
        MegaGimmick megaGimmick = RegistryLocator.getComponent(MegaGimmick.class, heldItem);
        if (megaGimmick != null || pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (pokemon.getSpecies().getName().equals("Rayquaza")) {
                Effect.getEffect("mega_showdown:mega_evolution").applyEffectsBattle(pokemon, List.of("mega_evolution=mega"), null, battlePokemon);
                AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), List.of("mega_evolution=none"), pokemon, "battle_end_revert");
            } else if (megaGimmick.canMega(pokemon)) {
                Effect.getEffect("mega_showdown:mega_evolution").applyEffectsBattle(pokemon, megaGimmick.aspect_conditions.apply_aspects(), null, battlePokemon);
                AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), megaGimmick.aspect_conditions.revert_aspects(), pokemon, "battle_end_revert");
            }
        }
    }

    private static void megaEvolve(Pokemon pokemon, List<String> aspects, List<String> revertAspects) {
        AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), revertAspects, pokemon, "revert_aspects");
        Effect.getEffect("mega_showdown:mega_evolution").applyEffects(pokemon, aspects, null);
        pokemon.setTradeable(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void megaToggle(Pokemon pokemon) {
        boolean found;
        if (!MegaShowdownConfig.outSideMega) return;
        if (pokemon == null) return;
        if (pokemon.getPersistentData().method_10577("form_changing")) {
            return;
        }
        class_3222 player = pokemon.getOwnerPlayer();
        class_1799 heldItem = pokemon.heldItem();
        MegaGimmick megaGimmick = RegistryLocator.getComponent(MegaGimmick.class, heldItem);
        if (megaGimmick == null && !pokemon.getSpecies().getName().equals("Rayquaza")) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.no_or_incorrect_mega_stone").method_27692(class_124.field_1061), true);
            return;
        }
        if (pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) {
            if (pokemon.getSpecies().getName().equals("Rayquaza")) {
                Effect.getEffect("mega_showdown:mega_evolution").revertEffects(pokemon, List.of("mega_evolution=none"), null);
            } else {
                Effect.getEffect("mega_showdown:mega_evolution").revertEffects(pokemon, megaGimmick.aspect_conditions.revert_aspects(), null);
            }
            pokemon.setTradeable(true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (player != null && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET) && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.OMNI_RING)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.no_mega_bracelet").method_27692(class_124.field_1061), true);
                return;
            }
            found = false;
        } else {
            if (!megaGimmick.canMega(pokemon)) return;
            if (player != null && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET) && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.OMNI_RING)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.no_mega_bracelet").method_27692(class_124.field_1061), true);
                return;
            }
            MegaGimmick.megaEvolve(pokemon, megaGimmick.aspect_conditions.apply_aspects(), megaGimmick.aspect_conditions.revert_aspects());
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
            MegaGimmick.megaEvolve(pokemon, List.of("mega_evolution=mega"), List.of("mega_evolution=none"));
            found = true;
            break;
        }
        if (found) return;
        if (player == null) return;
        player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.rayquaza_no_dragonascent").method_27692(class_124.field_1061), true);
    }

    public boolean canMega(Pokemon pokemon) {
        class_3222 player = pokemon.getOwnerPlayer();
        if (player != null && MegaGimmick.hasMega(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.mega_limit").method_27692(class_124.field_1061), true);
            return false;
        }
        if (!this.aspect_conditions.validate_apply(pokemon)) {
            return false;
        }
        return this.pokemons.contains(pokemon.getSpecies().getName());
    }
}

