/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown;

import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.block.MegaOres;
import com.cobblemon.yajatkaul.mega_showdown.block.ModBlocks;
import com.cobblemon.yajatkaul.mega_showdown.block.entity.ModBlockEntities;
import com.cobblemon.yajatkaul.mega_showdown.block.entity.renderer.PedestalBlockEntityRenderer;
import com.cobblemon.yajatkaul.mega_showdown.commands.MegaCommands;
import com.cobblemon.yajatkaul.mega_showdown.creativeTab.ModCreativeModeTabs;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.event.CobbleEvents;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.ItemsRegistration;
import com.cobblemon.yajatkaul.mega_showdown.item.inventory.ItemInventoryUtil;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.Controls;
import com.cobblemon.yajatkaul.mega_showdown.networking.NetworkHandler;
import com.cobblemon.yajatkaul.mega_showdown.networking.packets.MegaEvo;
import com.cobblemon.yajatkaul.mega_showdown.networking.packets.UltraTrans;
import com.cobblemon.yajatkaul.mega_showdown.screen.ModMenuTypes;
import com.cobblemon.yajatkaul.mega_showdown.screen.custom.ZygardeCubeScreen;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.PackRegister;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mega_showdown")
public final class MegaShowdown {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mega Showdown");
    public static final String MOD_ID = "mega_showdown";
    public static final ItemCapability<ItemInventoryUtil, Void> ITEM_STORAGE = ItemCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"item_storage"), ItemInventoryUtil.class);

    public MegaShowdown(IEventBus modEventBus, @NotNull ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        MegaOres.register();
        ModSounds.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ItemsRegistration.register(modEventBus);
        DataManage.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(NetworkHandler::register);
        NeoForge.EVENT_BUS.addListener(MegaCommands::register);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCapabilities);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.GRACIDEA_FLOWER.getId(), ModBlocks.POTTED_GRACIDEA));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(ITEM_STORAGE, (itemStack, ctx) -> new ItemInventoryUtil(), new ItemLike[]{(ItemLike)FormeChangeItems.ZYGARDE_CUBE.get()});
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Utils.registerRemapping();
        TeraTypeHelper.loadShardData();
        CobbleEvents.register();
    }

    @EventBusSubscriber(modid="mega_showdown", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            NeoForge.EVENT_BUS.addListener(ClientModEvents::onClientTick);
        }

        @SubscribeEvent
        public static void onAddPackFinders(AddPackFindersEvent event) {
            PackRegister.register(event);
        }

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)Controls.MEGA_ITEM_KEY.get());
            event.register((KeyMapping)Controls.ULTRA_KEY.get());
        }

        public static void onClientTick(ClientTickEvent.Post event) {
            while (((KeyMapping)Controls.MEGA_ITEM_KEY.get()).consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MegaEvo("mega_evo"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            while (((KeyMapping)Controls.ULTRA_KEY.get()).consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UltraTrans("ultra_trans"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.PEDESTAL_BE.get(), PedestalBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.ZYGARDE_CUBE_MENU.get(), ZygardeCubeScreen::new);
        }
    }
}

