/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.block;

import com.cobblemon.yajatkaul.mega_showdown.block.ModBlocks;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.CrystalBlock;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;

public class MegaOres {
    public static final DeferredBlock<Block> KEYSTONE_ORE = MegaOres.registerBlock("keystone_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)6, (int)9), BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.AMETHYST)));
    public static final DeferredBlock<AmethystClusterBlock> MEGA_STONE_CRYSTAL = MegaOres.registerBlock("mega_stone_crystal", () -> new CrystalBlock(4.0f, 3.0f, BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.MEDIUM_AMETHYST_BUD).noOcclusion().requiresCorrectToolForDrops().pushReaction(PushReaction.PUSH_ONLY).lightLevel(state -> 15)){
        public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

        protected VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
            return SHAPE;
        }

        public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            for (int i = 0; i < 3; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 0.5;
                double offsetY = (random.nextDouble() - 0.5) * 0.5;
                double offsetZ = (random.nextDouble() - 0.5) * 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    });
    public static final DeferredBlock<Block> MEGA_METEORID_WATER_ORE = MegaOres.registerBlock("mega_meteorid_water_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_DAWN_ORE = MegaOres.registerBlock("mega_meteorid_dawn_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_DUSK_ORE = MegaOres.registerBlock("mega_meteorid_dusk_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_FIRE_ORE = MegaOres.registerBlock("mega_meteorid_fire_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_ICE_ORE = MegaOres.registerBlock("mega_meteorid_ice_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_LEAF_ORE = MegaOres.registerBlock("mega_meteorid_leaf_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_MOON_ORE = MegaOres.registerBlock("mega_meteorid_moon_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_SHINY_ORE = MegaOres.registerBlock("mega_meteorid_shiny_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_SUN_ORE = MegaOres.registerBlock("mega_meteorid_sun_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEORID_THUNDER_ORE = MegaOres.registerBlock("mega_meteorid_thunder_ore", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = ModBlocks.BLOCKS.register(name, block);
        MegaOres.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register() {
    }
}

