/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import top.theillusivec4.curios.api.event.CurioCanUnequipEvent;

@EventBusSubscriber(modid="mega_showdown", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(3)).add((entity, randomSource) -> new MerchantOffer(new ItemCost(MegaStones.MEGA_STONE, 1), ModEvents.createExplorerMap(entity.level(), entity.getOnPos(), entity), 1, 6, 0.05f));
        }
    }

    private static ItemStack createExplorerMap(Level level, BlockPos pos, Entity entity) {
        if (!(level instanceof ServerLevel)) {
            return ItemStack.EMPTY;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        TagKey megaroidStructureTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mega_showdown", (String)"megaroid"));
        LootItemFunction mapFunction = new ExplorationMapFunction.Builder().setDestination(megaroidStructureTag).setZoom((byte)2).setSearchRadius(1000).setMapDecoration(MapDecorationTypes.RED_X).setSkipKnownStructures(true).build();
        ItemStack mapStack = new ItemStack((ItemLike)Items.MAP);
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)entity.level().damageSources().generic()).create(LootContextParamSets.ENTITY);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        mapStack = (ItemStack)mapFunction.apply((Object)mapStack, (Object)lootContext);
        mapStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"message.mega_showdown.lost_map"));
        List<MutableComponent> loreLines = List.of(Component.translatable((String)"message.mega_showdown.lost_map.desc"));
        mapStack.set(DataComponents.LORE, (Object)new ItemLore(loreLines));
        return mapStack;
    }

    @SubscribeEvent
    public static void onCurioChange(CurioCanUnequipEvent event) {
        ServerPlayer player;
        PokemonBattle battle;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player = (ServerPlayer)livingEntity)) != null && event.getStack().is(TeraMoves.TERA_ORB)) {
            event.setUnequipResult(TriState.FALSE);
        }
    }

    @SubscribeEvent
    private static void onServerJoin(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
        if (!playerLoggedInEvent.getEntity().level().isClientSide) {
            ServerPlayer player = (ServerPlayer)playerLoggedInEvent.getEntity();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemon : playerPartyStore) {
                if (Config.battleModeOnly) {
                    new FlagSpeciesFeature("mega", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                }
                EventUtils.revertFormesEnd(pokemon);
            }
            if (Config.battleModeOnly) {
                player.setData(DataManage.MEGA_DATA, (Object)false);
            }
        }
    }

    @SubscribeEvent
    private static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().level().isClientSide) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemon : playerPartyStore) {
                if (Config.battleModeOnly) {
                    new FlagSpeciesFeature("mega", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-x", false).apply(pokemon);
                    new FlagSpeciesFeature("mega-y", false).apply(pokemon);
                }
                EventUtils.revertFormesEnd(pokemon);
            }
            if (Config.battleModeOnly) {
                player.setData(DataManage.MEGA_DATA, (Object)false);
            }
        }
    }
}

