/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.event.dynamax.DynamaxEventListener;
import com.cobblemon.yajatkaul.mega_showdown.item.CompiItems;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraAccessor;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EventUtils {
    public static void revertFormesEnd(Pokemon pokemon) {
        if (pokemon.getEntity() != null) {
            pokemon.getEntity().removeEffect(MobEffects.GLOWING);
            DynamaxEventListener.startGradualScaling((LivingEntity)pokemon.getEntity(), 1.0f);
        }
        if (pokemon instanceof TeraAccessor) {
            TeraAccessor pk = (TeraAccessor)pokemon;
            pk.setTeraEnabled(false);
        }
        if (Config.revertMegas && !Config.multipleMegas && (pokemon.getAspects().contains("mega_x") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega"))) {
            MegaLogic.Devolve(pokemon, true);
        }
        new StringSpeciesFeature("dynamax_form", "none").apply(pokemon);
        if (pokemon.getSpecies().getName().equals("Castform")) {
            new StringSpeciesFeature("forecast_form", "normal").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Aegislash")) {
            new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Greninja") && pokemon.getAspects().contains("ash")) {
            new StringSpeciesFeature("battle_bond", "bond").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Morpeko")) {
            new StringSpeciesFeature("hunger_mode", "full_belly").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Mimikyu")) {
            new StringSpeciesFeature("disguise_form", "disguised").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Wishiwashi")) {
            new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Eiscue")) {
            new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Cramorant")) {
            new StringSpeciesFeature("missile_form", "none").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Palafin")) {
            new StringSpeciesFeature("dolphin_form", "zero").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Cherrim")) {
            new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Darmanitan")) {
            new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Arceus") && pokemon.heldItem().is(CompiItems.LEGEND_PLATE)) {
            new StringSpeciesFeature("multitype", "normal").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Xerneas")) {
            new StringSpeciesFeature("life_mode", "neutral").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.getAspects().contains("ultra")) {
            if (pokemon.getEntity() != null) {
                EventUtils.ultraAnimation((LivingEntity)pokemon.getEntity());
            }
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            new StringSpeciesFeature("tera_form", "normal").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Meloetta")) {
            new StringSpeciesFeature("song_forme", "aria").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Zygarde")) {
            new FlagSpeciesFeature("complete-percent", false).apply(pokemon);
        }
    }

    public static void playFormeChangeAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void playFormeChangeAngryAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(10.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void ultraAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityWidth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void playEvolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

