/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ArceusPlates;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Drives;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Memories;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HeldItemChangeFormes {
    public static void genesectChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Genesect")) {
            if (post.getReceived().is(FormeChangeItems.DOUSE_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "water").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.BURN_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "fire").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.CHILL_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "ice").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.SHOCK_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "electric").apply(pokemon);
            } else if (!(post.getReceived().getItem() instanceof Drives) && post.getReturned().getItem() instanceof Drives) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "none").apply(pokemon);
            }
        }
    }

    public static void silvallyChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Silvally")) {
            if (post.getReceived().is(FormeChangeItems.BUG_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "bug").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.DARK_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "dark").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.DRAGON_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "dragon").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.ELECTRIC_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "electric").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.FAIRY_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "fairy").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.FIGHTING_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "fighting").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.FIRE_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "fire").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.FLYING_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "flying").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.GHOST_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "ghost").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.GRASS_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "grass").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.GROUND_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "ground").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.ICE_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "ice").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.POISON_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "poison").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.PSYCHIC_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "psychic").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.ROCK_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "rock").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.STEEL_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "steel").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.WATER_MEMORY)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "water").apply(pokemon);
            } else if (!(post.getReceived().getItem() instanceof Memories) && post.getReturned().getItem() instanceof Memories) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "normal").apply(pokemon);
            }
        }
    }

    public static void arcuesChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Arceus")) {
            if (post.getReceived().is(FormeChangeItems.FLAME_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fire").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.SPLASH_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "water").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.ZAP_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "electric").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.MEADOW_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "grass").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.ICICLE_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ice").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.FIST_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fighting").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.TOXIC_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "poison").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.EARTH_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ground").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.SKY_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "flying").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.MIND_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "psychic").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.INSECT_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "bug").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.STONE_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "rock").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.SPOOKY_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ghost").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.DRACO_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "dragon").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.DREAD_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "dark").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.IRON_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "steel").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.PIXIE_PLATE)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fairy").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.BUGINIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "bug").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.DARKINIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "dark").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.DRAGONIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "dragon").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.ELECTRIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "electric").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.FAIRIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fairy").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.FIGHTINIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fighting").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.FIRIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "fire").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.FLYINIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "flying").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.GHOSTIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ghost").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.GRASSIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "grass").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.GROUNDIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ground").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.ICIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "ice").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.POISONIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "poison").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.PSYCHIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "psychic").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.ROCKIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "rock").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.STEELIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "steel").apply(pokemon);
            } else if (post.getReceived().is(ZCrystals.WATERIUM_Z)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "water").apply(pokemon);
            } else if (!(post.getReceived().getItem() instanceof ArceusPlates) && post.getReturned().getItem() instanceof ArceusPlates) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "normal").apply(pokemon);
            }
        }
    }

    public static void originChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (post.getReceived().is(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.ASH);
                new StringSpeciesFeature("orb_forme", "origin").apply(pokemon);
            } else if (post.getReturned().is(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.ASH);
                new StringSpeciesFeature("orb_forme", "altered").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Palkia")) {
            if (post.getReceived().is(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.END_ROD);
                new StringSpeciesFeature("orb_forme", "origin").apply(pokemon);
            } else if (post.getReturned().is(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.END_ROD);
                new StringSpeciesFeature("orb_forme", "altered").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Dialga")) {
            if (post.getReceived().is(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.END_ROD);
                new StringSpeciesFeature("orb_forme", "origin").apply(pokemon);
            } else if (post.getReturned().is(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation((LivingEntity)pokemon.getEntity(), ParticleTypes.END_ROD);
                new StringSpeciesFeature("orb_forme", "altered").apply(pokemon);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Post post) {
        if (!Config.etermaxForme) {
            return;
        }
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Eternatus") && post.getReceived().is(FormeChangeItems.STAR_CORE)) {
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Eternatus")) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
        }
    }

    public static void ogerponChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (post.getReceived().is(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getFIRE());
        } else if (post.getReceived().is(FormeChangeItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getROCK());
        } else if (post.getReceived().is(FormeChangeItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getWATER());
        } else {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getGRASS());
        }
    }

    public static void primalEvent(HeldItemEvent.Pre pre) {
        ServerPlayer player = pre.getPokemon().getOwnerPlayer();
        Species species = pre.getPokemon().getSpecies();
        if (!species.getName().equals("Kyogre") && !species.getName().equals("Groudon")) {
            return;
        }
        if (!player.hasData(DataManage.PRIMAL_DATA)) {
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
        }
        boolean primalData = (Boolean)player.getData(DataManage.PRIMAL_DATA);
        if (species.getName().equals("Kyogre") && pre.getReceiving().is(MegaStones.BLUE_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || Config.multiplePrimals) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.BUBBLE, true);
                player.setData(DataManage.PRIMAL_DATA, (Object)true);
                player.setData(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.primal_limit").withColor(0xFF0000), true);
            }
        } else if (species.getName().equals("Groudon") && pre.getReceiving().is(MegaStones.RED_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || Config.multiplePrimals) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.CAMPFIRE_COSY_SMOKE, true);
                player.setData(DataManage.PRIMAL_DATA, (Object)true);
                player.setData(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.primal_limit").withColor(0xFF0000), true);
            }
        } else if (species.getName().equals("Kyogre") && !pre.getReceiving().is(MegaStones.BLUE_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.END_ROD, false);
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            player.removeData(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        } else if (species.getName().equals("Groudon") && !pre.getReceiving().is(MegaStones.RED_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.END_ROD, false);
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            player.removeData(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        }
    }

    public static void megaEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getAspects().contains("mega_x") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega")) {
            MegaLogic.Devolve(pokemon, true);
        }
    }

    public static void crownedEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceived().is(FormeChangeItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                HeldItemChangeFormes.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (event.getReceived().is(FormeChangeItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                HeldItemChangeFormes.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturned().is(FormeChangeItems.RUSTED_SWORD)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturned().is(FormeChangeItems.RUSTED_SHIELD)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            }
        }
    }

    public static void ultraEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.getAspects().contains("ultra") && event.getReturned().is(ZCrystals.ULTRANECROZIUM_Z)) {
            if (!pokemon.getEntity().isBattling()) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            }
            EventUtils.ultraAnimation((LivingEntity)pokemon.getEntity());
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        }
    }

    private static void playHeldItemChange(LivingEntity context) {
        LazyLib.Companion.cryAnimation((Entity)context);
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void originAnimation(LivingEntity context, SimpleParticleType particleType) {
        LazyLib.Companion.cryAnimation((Entity)context);
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void crownAnimation(ServerLevel level, BlockPos pos, LivingEntity context) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
        if (lightning != null) {
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            lightning.setVisualOnly(true);
            level.addFreshEntity((Entity)lightning);
            HeldItemChangeFormes.playHeldItemChange(context);
        }
    }

    private static void primalRevertAnimation(PokemonEntity context, SimpleParticleType particleType, Boolean revert) {
        Level level;
        if (revert.booleanValue()) {
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(2.5f, () -> {
                LazyLib.Companion.cryAnimation((Entity)context);
                context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        }
        if ((level = context.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

