/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.dynamax;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.event.dynamax.DynamaxEvent;
import com.cobblemon.yajatkaul.mega_showdown.event.dynamax.DynamaxEventEnd;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class DynamaxEventListener {
    private static final Map<UUID, ScalingData> activeScalingAnimations = new HashMap<UUID, ScalingData>();
    private static final WeakHashMap<UUID, LivingEntity> entityCache = new WeakHashMap();
    private static MinecraftServer server;

    @SubscribeEvent
    public void onDynamax(DynamaxEvent event) {
        ServerLevel serverLevel;
        Level level;
        PokemonEntity entity = event.getPokemon().getEntity();
        Vec3 entityPos = entity.position();
        entity.level().playSound(null, entityPos.x, entityPos.y, entityPos.z, ModSounds.DYNAMAX.get(), SoundSource.PLAYERS, 0.4f, 0.5f + (float)Math.random() * 0.5f);
        if (entity == null) {
            return;
        }
        if (event.getGmax().booleanValue()) {
            new StringSpeciesFeature("dynamax_form", "gmax").apply(event.getPokemon().getEffectedPokemon());
            BattlePokemon pokemon = event.getPokemon();
            level = event.getBattle().getActivePokemon().iterator();
            while (level.hasNext()) {
                ActiveBattlePokemon activeBattlePokemon = (ActiveBattlePokemon)level.next();
                if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pokemon) continue;
                event.getBattle().sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, false), false);
            }
            AdvancementHelper.grantAdvancement(entity.getPokemon().getOwnerPlayer(), "dynamax/gigantamax");
        } else {
            AdvancementHelper.grantAdvancement(entity.getPokemon().getOwnerPlayer(), "dynamax/dynamax");
        }
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
        if (server == null && (level = entity.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            server = serverLevel.getServer();
        }
        DynamaxEventListener.startGradualScaling((LivingEntity)entity, Config.dynamaxScaleFactor);
        level = entity.level();
        if (level instanceof ServerLevel) {
            String teamName;
            serverLevel = (ServerLevel)level;
            ServerScoreboard scoreboard = serverLevel.getScoreboard();
            PlayerTeam team = scoreboard.getPlayerTeam(teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8));
            if (team == null) {
                team = scoreboard.addPlayerTeam(teamName);
                if (event.getPokemon().getEffectedPokemon().getSpecies().getName().equals("Calyrex")) {
                    team.setColor(ChatFormatting.BLUE);
                } else {
                    team.setColor(ChatFormatting.RED);
                }
            }
            scoreboard.addPlayerToTeam(entity.getUUID().toString(), team);
        }
        event.getBattle().dispatchWaitingToFront(3.0f, () -> {
            LazyLib.Companion.cryAnimation((Entity)event.getPokemon().getEffectedPokemon().getEntity());
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void onDynamaxEnd(DynamaxEventEnd event) {
        Level level;
        new StringSpeciesFeature("dynamax_form", "none").apply(event.getPokemon().getEffectedPokemon());
        BattlePokemon pokemon = event.getPokemon();
        for (ActiveBattlePokemon activeBattlePokemon : event.getBattle().getActivePokemon()) {
            if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pokemon) continue;
            event.getBattle().sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, false), false);
        }
        PokemonEntity entity = event.getPokemon().getEntity();
        if (entity == null) {
            return;
        }
        entity.removeEffect(MobEffects.GLOWING);
        if (server == null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            server = serverLevel.getServer();
        }
        DynamaxEventListener.startGradualScaling((LivingEntity)entity, 1.0f);
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        DynamaxEventListener.updateScalingAnimations();
    }

    public static void startGradualScaling(LivingEntity entity, float targetScale) {
        UUID entityId = entity.getUUID();
        AttributeInstance scaleAttr = entity.getAttribute(Attributes.SCALE);
        if (scaleAttr != null) {
            entityCache.put(entityId, entity);
            float startScale = (float)scaleAttr.getBaseValue();
            ScalingData scalingData = new ScalingData(entity.level().dimension().location().toString(), entityId, startScale, targetScale, 60, 0);
            activeScalingAnimations.put(entityId, scalingData);
        }
    }

    private static void updateScalingAnimations() {
        if (server == null) {
            return;
        }
        Iterator<Map.Entry<UUID, ScalingData>> iterator = activeScalingAnimations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ScalingData> entry = iterator.next();
            UUID entityId = entry.getKey();
            ScalingData data = entry.getValue();
            ++data.currentTick;
            LivingEntity entity = entityCache.get(entityId);
            if (entity == null || !entity.isAlive()) {
                for (ServerLevel world : server.getAllLevels()) {
                    entity = (LivingEntity)world.getEntity(entityId);
                    if (entity == null) continue;
                    entityCache.put(entityId, entity);
                    break;
                }
            }
            if (entity != null && entity.isAlive()) {
                AttributeInstance scaleAttr = entity.getAttribute(Attributes.SCALE);
                if (scaleAttr != null) {
                    float progress = Math.min(1.0f, (float)data.currentTick / (float)data.durationTicks);
                    float newScale = data.startScale + (data.targetScale - data.startScale) * progress;
                    scaleAttr.setBaseValue((double)newScale);
                }
                if (data.currentTick < data.durationTicks) continue;
                iterator.remove();
                entityCache.remove(entityId);
                continue;
            }
            iterator.remove();
            entityCache.remove(entityId);
        }
    }

    private static class ScalingData {
        final String worldId;
        final UUID entityId;
        final float startScale;
        final float targetScale;
        final int durationTicks;
        int currentTick;

        public ScalingData(String worldId, UUID entityId, float startScale, float targetScale, int durationTicks, int currentTick) {
            this.worldId = worldId;
            this.entityId = entityId;
            this.startScale = startScale;
            this.targetScale = targetScale;
            this.durationTicks = durationTicks;
            this.currentTick = currentTick;
        }
    }
}

