/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredItem;

public class RotomFormes {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;
    public static final DeferredItem<Item> FAN = ModItems.ITEMS.register("fanunit", () -> new Item(new Item.Properties()){

        public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
            Pokemon pokemon;
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching() && (pokemon = pk.getPokemon()).getSpecies().getName().equals("Rotom")) {
                if (!RotomFormes.possible((ServerPlayer)player)) {
                    return InteractionResult.PASS;
                }
                RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                if (pokemon.getAspects().contains("fan-appliance")) {
                    new StringSpeciesFeature("appliance", "none").apply(pk);
                    return InteractionResult.SUCCESS;
                }
                new StringSpeciesFeature("appliance", "fan").apply(pk);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                return InteractionResult.SUCCESS;
            }
            return super.interactLivingEntity(arg, player, context, arg4);
        }
    });
    public static final DeferredItem<Item> FRIDGEUNIT = ModItems.ITEMS.register("fridgeunit", () -> new Item(new Item.Properties()){

        public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching()) {
                Pokemon pokemon = pk.getPokemon();
                if (pk.getPokemon().getSpecies().getName().equals("Rotom")) {
                    if (!RotomFormes.possible((ServerPlayer)player)) {
                        return InteractionResult.PASS;
                    }
                    RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                    if (pokemon.getAspects().contains("frost-appliance")) {
                        new StringSpeciesFeature("appliance", "none").apply(pk);
                        return InteractionResult.SUCCESS;
                    }
                    new StringSpeciesFeature("appliance", "frost").apply(pk);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                    return InteractionResult.SUCCESS;
                }
            }
            return super.interactLivingEntity(arg, player, context, arg4);
        }
    });
    public static final DeferredItem<Item> MOWUNIT = ModItems.ITEMS.register("mowunit", () -> new Item(new Item.Properties()){

        public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching()) {
                Pokemon pokemon = pk.getPokemon();
                if (pk.getPokemon().getSpecies().getName().equals("Rotom")) {
                    if (!RotomFormes.possible((ServerPlayer)player)) {
                        return InteractionResult.PASS;
                    }
                    RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                    if (pokemon.getAspects().contains("mow-appliance")) {
                        new StringSpeciesFeature("appliance", "none").apply(pk);
                        return InteractionResult.SUCCESS;
                    }
                    new StringSpeciesFeature("appliance", "mow").apply(pk);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                    return InteractionResult.SUCCESS;
                }
            }
            return super.interactLivingEntity(arg, player, context, arg4);
        }
    });
    public static final DeferredItem<Item> OVENUNIT = ModItems.ITEMS.register("ovenunit", () -> new Item(new Item.Properties()){

        public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching()) {
                Pokemon pokemon = pk.getPokemon();
                if (pk.getPokemon().getSpecies().getName().equals("Rotom")) {
                    if (!RotomFormes.possible((ServerPlayer)player)) {
                        return InteractionResult.PASS;
                    }
                    RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                    if (pokemon.getAspects().contains("heat-appliance")) {
                        new StringSpeciesFeature("appliance", "none").apply(pk);
                        return InteractionResult.SUCCESS;
                    }
                    new StringSpeciesFeature("appliance", "heat").apply(pk);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                    return InteractionResult.SUCCESS;
                }
            }
            return super.interactLivingEntity(arg, player, context, arg4);
        }
    });
    public static final DeferredItem<Item> WASHUNIT = ModItems.ITEMS.register("washunit", () -> new Item(new Item.Properties()){

        public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching()) {
                Pokemon pokemon = pk.getPokemon();
                if (pk.getPokemon().getSpecies().getName().equals("Rotom")) {
                    if (!RotomFormes.possible((ServerPlayer)player)) {
                        return InteractionResult.PASS;
                    }
                    RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                    if (pokemon.getAspects().contains("wash-appliance")) {
                        new StringSpeciesFeature("appliance", "none").apply(pk);
                        return InteractionResult.SUCCESS;
                    }
                    new StringSpeciesFeature("appliance", "wash").apply(pk);
                    AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                    return InteractionResult.SUCCESS;
                }
            }
            return super.interactLivingEntity(arg, player, context, arg4);
        }
    });
    public static final DeferredItem<Item> ROTOM_CATALOGUE = ModItems.ITEMS.register("rotom_catalogue", () -> new Item(new Item.Properties().component(DataManage.CATALOGUE_PAGE, (Object)1)){

        public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity context, InteractionHand hand) {
            Pokemon pokemon;
            PokemonEntity pk;
            if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching() && (pokemon = pk.getPokemon()).getSpecies().getName().equals("Rotom")) {
                if (!RotomFormes.possible((ServerPlayer)player)) {
                    return InteractionResult.PASS;
                }
                RotomFormes.playFormeChangeAnimation((LivingEntity)pk);
                int currentPage = (Integer)stack.getOrDefault(DataManage.CATALOGUE_PAGE, (Object)1);
                switch (currentPage) {
                    case 1: {
                        new StringSpeciesFeature("appliance", "heat").apply(pk);
                        AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                        break;
                    }
                    case 2: {
                        new StringSpeciesFeature("appliance", "fan").apply(pk);
                        AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                        break;
                    }
                    case 3: {
                        new StringSpeciesFeature("appliance", "mow").apply(pk);
                        AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                        break;
                    }
                    case 4: {
                        new StringSpeciesFeature("appliance", "frost").apply(pk);
                        AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                        break;
                    }
                    case 5: {
                        new StringSpeciesFeature("appliance", "wash").apply(pk);
                        AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
                        break;
                    }
                    default: {
                        new StringSpeciesFeature("appliance", "none").apply(pk);
                    }
                }
                int nextPage = currentPage + 1;
                if (nextPage == 7) {
                    nextPage = 1;
                }
                stack.set(DataManage.CATALOGUE_PAGE, (Object)nextPage);
                player.setItemInHand(hand, stack);
                player.getInventory().setChanged();
                return InteractionResult.SUCCESS;
            }
            return super.interactLivingEntity(stack, player, context, hand);
        }
    });

    public static boolean possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void playFormeChangeAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void register() {
    }
}

