/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Unbound
extends Item {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 3000L;

    public Unbound(Item.Properties arg) {
        super(arg);
    }

    public static boolean Possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 3000L);
        return true;
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity context, InteractionHand hand) {
        PokemonEntity pk;
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && Unbound.Possible((ServerPlayer)player) && pk.getPokemon().getSpecies().getName().equals("Hoopa")) {
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getAspects().contains("unbound")) {
                new StringSpeciesFeature("djinn_state", "confined").apply(pokemon);
                Unbound.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                return InteractionResult.SUCCESS;
            }
            new StringSpeciesFeature("djinn_state", "unbound").apply(pokemon);
            Unbound.unboundAnimation((LivingEntity)pokemon.getEntity());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void playEvolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void unboundAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 4.0;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, (Holder)SoundEvents.NOTE_BLOCK_IMITATE_ENDER_DRAGON, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

