/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.inventory.ItemInventoryUtil;
import com.cobblemon.yajatkaul.mega_showdown.screen.custom.ZygardeCubeMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ZygardeCube
extends Item {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public static boolean possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public ZygardeCube(Item.Properties arg) {
        super(arg);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        PokemonEntity pk;
        Entity entity;
        if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        EntityHitResult entityHit = ZygardeCube.getEntityLookingAt(player, 4.5f);
        if (entityHit != null && (entity = entityHit.getEntity()) instanceof PokemonEntity && (pk = (PokemonEntity)entity).getPokemon().getSpecies().getName().equals("Zygarde")) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ItemStack stack = player.getItemInHand(hand);
        ItemInventoryUtil inventory = new ItemInventoryUtil(stack, player);
        CompoundTag capTag = (CompoundTag)stack.get(DataManage.ZYGARDE_INV);
        RegistryAccess provider = level.registryAccess();
        ItemStackHandler handler = inventory.getHandler();
        if (capTag != null) {
            handler.deserializeNBT((HolderLookup.Provider)provider, capTag);
        }
        CompoundTag serializedTag = handler.serializeNBT((HolderLookup.Provider)provider);
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new ZygardeCubeMenu(id, playerInventory, handler), (Component)Component.translatable((String)"menu.zygade_cube")), buf -> buf.writeNbt((Tag)serializedTag));
        return InteractionResultHolder.success((Object)stack);
    }

    public static EntityHitResult getEntityLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        AABB rayTraceBox = new AABB(eyePos, targetPos);
        return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)targetPos, (AABB)rayTraceBox, entity -> !entity.isSpectator() && entity instanceof LivingEntity && entity.isPickable(), (float)0.3f);
    }

    public ItemStackHandler getInventory(ItemStack stack, Level level, Player player) {
        CompoundTag capTag = (CompoundTag)stack.get(DataManage.ZYGARDE_INV);
        RegistryAccess provider = level.registryAccess();
        ItemInventoryUtil inventory = new ItemInventoryUtil(stack, player);
        ItemStackHandler handler = inventory.getHandler();
        if (capTag != null) {
            handler.deserializeNBT((HolderLookup.Provider)provider, capTag);
        }
        return handler;
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity entity, InteractionHand arg4) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.FAIL;
        }
        if (entity instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity;
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getEntity() == null || pokemon.getEntity().level().isClientSide || pokemon.getEntity().isBattling()) {
                return InteractionResult.PASS;
            }
            if (!pokemon.getSpecies().getName().equals("Zygarde")) {
                return InteractionResult.PASS;
            }
            if (arg4 == InteractionHand.OFF_HAND && !pk.getAspects().contains("power-construct")) {
                if (arg.get(DataManage.ZYGARDE_CUBE_DATA) != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.cube_full").withColor(0xFF0000), true);
                    return InteractionResult.FAIL;
                }
                arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube.full"));
                arg.set(DataManage.ZYGARDE_CUBE_DATA, (Object)new PokeHandler(pokemon));
                Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).remove(pokemon);
                player.setItemInHand(arg4, arg);
                return InteractionResult.SUCCESS;
            }
            if (pk.getAspects().contains("power-construct")) {
                if (!ZygardeCube.possible((ServerPlayer)player)) {
                    return InteractionResult.PASS;
                }
                if (pk.getAspects().contains("10-percent")) {
                    this.particleEffect((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("percent_cells", "50").apply(pk);
                } else {
                    this.particleEffect((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("percent_cells", "10").apply(pk);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.resassembly_zygarde_req").withColor(0xFF0000), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void particleEffect(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 0.8;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public void onDestroyed(ItemEntity entity, DamageSource damageSource) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            PokeHandler refValue = (PokeHandler)entity.getItem().getOrDefault(DataManage.ZYGARDE_CUBE_DATA, null);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            if (currentValue != null) {
                playerPartyStore.add(currentValue);
                entity.getItem().set(DataManage.ZYGARDE_CUBE_DATA, null);
            }
        }
        super.onDestroyed(entity, damageSource);
    }
}

