/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DNA_Splicer
extends Item {
    public DNA_Splicer(Item.Properties arg) {
        super(arg);
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, @NotNull LivingEntity context, InteractionHand hand) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (!(context instanceof PokemonEntity)) {
            return InteractionResult.PASS;
        }
        PokemonEntity pk = (PokemonEntity)context;
        Pokemon pokemon = pk.getPokemon();
        if (pokemon.getOwnerPlayer() != player || pokemon.getEntity() == null) {
            return InteractionResult.PASS;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        PokeHandler refValue = (PokeHandler)arg.getOrDefault(DataManage.KYUREM_DATA, null);
        Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
        if (pokemon.getSpecies().getName().equals("Kyurem") && this.checkEnabled(pokemon)) {
            if (arg.get(DataManage.KYUREM_DATA) != null) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withColor(0xFF0000), true);
                return InteractionResult.PASS;
            }
            DNA_Splicer.particleEffect((LivingEntity)pk, ParticleTypes.ASH);
            new FlagSpeciesFeature("white", false).apply(pokemon);
            new FlagSpeciesFeature("black", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
            if (!pokemon.getEntity().hasData(DataManage.KYUREM_FUSED_WITH)) {
                HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
                Pokemon toAdd = (Pokemon)map.get(pokemon.getUuid());
                playerPartyStore.add(toAdd);
                map.remove(pokemon.getUuid());
                player.setData(DataManage.DATA_MAP, (Object)map);
            } else {
                playerPartyStore.add(((PokeHandler)pokemon.getEntity().getData(DataManage.KYUREM_FUSED_WITH)).getPokemon());
                pokemon.getEntity().removeData(DataManage.KYUREM_FUSED_WITH);
            }
            arg.set(DataManage.KYUREM_DATA, null);
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.dna_splicer.inactive"));
        } else if (currentValue != null && pokemon.getSpecies().getName().equals("Kyurem")) {
            if (currentValue.getSpecies().getName().equals("Reshiram")) {
                DNA_Splicer.particleEffect((LivingEntity)pk, ParticleTypes.END_ROD);
                new FlagSpeciesFeature("white", true).apply(pokemon);
            } else {
                DNA_Splicer.particleEffect((LivingEntity)pk, ParticleTypes.SMOKE);
                new FlagSpeciesFeature("black", true).apply(pokemon);
            }
            Utils.setTradable(pokemon, false);
            pokemon.getEntity().setData(DataManage.KYUREM_FUSED_WITH, (Object)new PokeHandler(currentValue));
            HashMap<UUID, Pokemon> map = (HashMap<UUID, Pokemon>)player.getData(DataManage.DATA_MAP);
            if (map == null) {
                map = new HashMap<UUID, Pokemon>();
            }
            map.put(pokemon.getUuid(), currentValue);
            player.setData(DataManage.DATA_MAP, map);
            arg.set(DataManage.KYUREM_DATA, null);
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.dna_splicer.inactive"));
        } else if (currentValue == null && pokemon.getSpecies().getName().equals("Reshiram")) {
            arg.set(DataManage.KYUREM_DATA, (Object)new PokeHandler(pk.getPokemon()));
            playerPartyStore.remove(pk.getPokemon());
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.dna_splicer.charged"));
        } else if (currentValue == null && pokemon.getSpecies().getName().equals("Zekrom")) {
            arg.set(DataManage.KYUREM_DATA, (Object)new PokeHandler(pk.getPokemon()));
            playerPartyStore.remove(pk.getPokemon());
            arg.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.dna_splicer.charged"));
        } else {
            return InteractionResult.PASS;
        }
        player.setItemInHand(hand, arg);
        player.getInventory().setChanged();
        return InteractionResult.SUCCESS;
    }

    private boolean checkEnabled(Pokemon pokemon) {
        boolean enabled;
        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("black"));
        FlagSpeciesFeature feature = featureProvider.get(pokemon);
        if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
            return true;
        }
        featureProvider = new FlagSpeciesFeatureProvider(List.of("white"));
        feature = featureProvider.get(pokemon);
        return feature != null && (enabled = featureProvider.get(pokemon).getEnabled());
    }

    public static void particleEffect(LivingEntity conComponent, SimpleParticleType particleType) {
        Level level = conComponent.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = conComponent.position();
            double entityWidth = conComponent.getBbWidth();
            double entityHeight = conComponent.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public void onDestroyed(ItemEntity entity, DamageSource damageSource) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            PokeHandler refValue = (PokeHandler)entity.getItem().getOrDefault(DataManage.KYUREM_DATA, null);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            if (currentValue != null) {
                playerPartyStore.add(currentValue);
                entity.getItem().set(DataManage.KYUREM_DATA, null);
            }
        }
        super.onDestroyed(entity, damageSource);
    }
}

