/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.inventory;

import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemInventoryUtil {
    private final ItemStackHandler handler;

    public ItemInventoryUtil() {
        this.handler = new ItemStackHandler(this, 2){

            protected int getStackLimit(int slot, ItemStack stack) {
                if (slot == 1) {
                    return 5;
                }
                return 95;
            }
        };
    }

    public ItemInventoryUtil(final ItemStack stack, final Player player) {
        this.handler = new ItemStackHandler(this, 2){

            protected int getStackLimit(int slot, ItemStack stack2) {
                if (slot == 1) {
                    return 5;
                }
                return 95;
            }

            protected void onContentsChanged(int slot) {
                RegistryAccess provider = player.level().registryAccess();
                CompoundTag updatedTag = this.serializeNBT((HolderLookup.Provider)provider);
                stack.set(DataManage.ZYGARDE_INV, (Object)updatedTag);
                player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            }

            public ItemStack insertItem(int slot, ItemStack stack2, boolean simulate) {
                if (stack2.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                ItemStack existing = this.getStackInSlot(slot);
                int limit = this.getStackLimit(slot, stack2);
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)existing)) {
                    if (!existing.isEmpty()) {
                        return stack2;
                    }
                    if (stack2.getCount() > limit) {
                        ItemStack remainder = stack2.copy();
                        if (!simulate) {
                            ItemStack newStack = stack2.copy();
                            newStack.setCount(limit);
                            this.setStackInSlot(slot, newStack);
                        }
                        remainder.setCount(stack2.getCount() - limit);
                        return remainder;
                    }
                    if (!simulate) {
                        this.setStackInSlot(slot, stack2.copy());
                    }
                    return ItemStack.EMPTY;
                }
                int combined = existing.getCount() + stack2.getCount();
                if (combined <= limit) {
                    if (!simulate) {
                        existing.setCount(combined);
                        this.setStackInSlot(slot, existing);
                    }
                    return ItemStack.EMPTY;
                }
                int accepted = limit - existing.getCount();
                if (accepted <= 0) {
                    return stack2;
                }
                if (!simulate) {
                    existing.setCount(limit);
                    this.setStackInSlot(slot, existing);
                }
                ItemStack remainder = stack2.copy();
                remainder.setCount(stack2.getCount() - accepted);
                return remainder;
            }
        };
    }

    public ItemStackHandler getHandler() {
        return this.handler;
    }
}

