/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class MegaLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public static boolean Possible(ServerPlayer player, boolean fromBattle) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId) && !fromBattle) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        boolean hasMegaItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.is(ModTags.Items.MEGA_BRACELETS))).orElse(false);
        boolean hasOffhandMegaItem = player.getOffhandItem().is(ModTags.Items.MEGA_BRACELETS);
        boolean hasMainhandMegaItem = player.getMainHandItem().is(ModTags.Items.MEGA_BRACELETS);
        if (fromBattle ? !hasMegaItemCurios && !hasOffhandMegaItem : !hasMegaItemCurios && !hasOffhandMegaItem && !hasMainhandMegaItem) {
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void EvoLogic(Player playerContext) {
        ServerPlayer player = (ServerPlayer)playerContext;
        if (Config.battleModeOnly) {
            return;
        }
        double range = 5.0;
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = startPos.add(lookVec.multiply(range, range, range));
        AABB searchBox = new AABB(startPos, endPos).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)searchBox, entity -> !entity.isSpectator() && entity.isPickable(), (float)0.3f);
        if (entityHit == null) {
            return;
        }
        Entity entity2 = entityHit.getEntity();
        if (entity2 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity2;
            if (pk.level().isClientSide) {
                return;
            }
            if (!Config.mega || pk.getPokemon().getOwnerPlayer() != player || !Utils.MEGA_POKEMONS.contains(pk.getPokemon().getSpecies().getName()) && !pk.getPokemon().getSpecies().getName().equals("Rayquaza") || !MegaLogic.Possible(player, false)) {
                return;
            }
            if (pk.getAspects().contains("mega_x") || pk.getAspects().contains("mega") || pk.getAspects().contains("mega_y")) {
                MegaLogic.Devolve(pk.getPokemon(), false);
            } else {
                MegaLogic.Evolve(pk, (Player)player, false);
            }
        }
    }

    public static void Evolve(PokemonEntity context, Player player, Boolean fromBattle) {
        PokemonEntity pk;
        if (context.getPokemon().getOwnerPlayer() != player) {
            return;
        }
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().getItem());
        if (context instanceof PokemonEntity && (pk = context).isBattling() && !fromBattle.booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.battle_not_allowed").withColor(0xFF0000), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza") && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            if (Config.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                player.setData(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.playEvolveAnimation(context);
                new StringSpeciesFeature("mega_evolution", "mega").apply(pokemon);
                Utils.setTradable(pokemon, false);
                found = true;
            }
            if (!found) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.rayquaza_no_dragonascent").withColor(0xFF0000), true);
            }
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza") && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.mega_limit").withColor(0xFF0000), true);
            return;
        }
        if (species == null) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
            return;
        }
        if (Config.friendshipMode && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.bond_not_close_mega").withColor(0xFF0000), true);
            return;
        }
        if (species.equals(pokemon.getSpecies().getName()) && (!((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue() || Config.multipleMegas)) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.playEvolveAnimation(context);
                    new StringSpeciesFeature("mega_evolution", "mega_x").apply(pokemon);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.CHARIZARDITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.playEvolveAnimation(context);
                    new StringSpeciesFeature("mega_evolution", "mega_y").apply(pokemon);
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().is(MegaStones.MEWTWONITE_X)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.playEvolveAnimation(context);
                    new StringSpeciesFeature("mega_evolution", "mega_x").apply(pokemon);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().is(MegaStones.MEWTWONITE_Y)) {
                    player.setData(DataManage.MEGA_DATA, (Object)true);
                    player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.playEvolveAnimation(context);
                    new StringSpeciesFeature("mega_evolution", "mega_y").apply(pokemon);
                    Utils.setTradable(pokemon, false);
                }
            } else {
                player.setData(DataManage.MEGA_DATA, (Object)true);
                player.setData(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                new StringSpeciesFeature("mega_evolution", "mega").apply(pokemon);
                Utils.setTradable(pokemon, false);
                MegaLogic.playEvolveAnimation(context);
            }
        } else if (species.equals(pokemon.getSpecies().getName()) && ((Boolean)player.getData(DataManage.MEGA_DATA)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.mega_limit").withColor(0xFF0000), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.incorrect_mega_stone").withColor(0xFF0000), true);
        }
    }

    public static void Devolve(Pokemon context, Boolean fromBattle) {
        ServerPlayer player = context.getOwnerPlayer();
        if (context instanceof Pokemon) {
            Pokemon pk = context;
            if (pk.getOwnerPlayer() != player) {
                return;
            }
            if (pk.getEntity() != null && pk.getEntity().isBattling() && !fromBattle.booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.battle_not_allowed").withColor(0xFF0000), true);
                return;
            }
            player.setData(DataManage.MEGA_DATA, (Object)false);
            player.removeData(DataManage.MEGA_POKEMON);
            if (context.getEntity() != null) {
                MegaLogic.playDevolveAnimation((LivingEntity)context.getEntity());
            }
            new StringSpeciesFeature("mega_evolution", "none").apply(pk);
            Utils.setTradable(pk, true);
        }
    }

    public static void playEvolveAnimation(PokemonEntity context) {
        AdvancementHelper.grantAdvancement(context.getPokemon().getOwnerPlayer(), "mega/mega_evolve");
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void playDevolveAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_DEACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

