/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.Config;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ZRingItem;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;

public class UltraLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public static boolean Possible(ServerPlayer player) {
        boolean hasMainhandUltraItem;
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        boolean hasUltraItemCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.getItem() instanceof ZRingItem || stack.is(ModTags.Items.Z_RINGS))).orElse(false);
        boolean hasOffhandUltraItem = player.getOffhandItem().getItem() instanceof ZRingItem || player.getOffhandItem().is(ModTags.Items.Z_RINGS);
        boolean bl = hasMainhandUltraItem = player.getMainHandItem().getItem() instanceof ZRingItem || player.getMainHandItem().is(ModTags.Items.Z_RINGS);
        if (!(hasUltraItemCurios || hasOffhandUltraItem || hasMainhandUltraItem)) {
            return false;
        }
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void ultraTransform(Player playerContext) {
        ServerPlayer player = (ServerPlayer)playerContext;
        double range = 5.0;
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = startPos.add(lookVec.multiply(range, range, range));
        AABB searchBox = new AABB(startPos, endPos).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)searchBox, entity -> !entity.isSpectator() && entity.isPickable(), (float)0.3f);
        if (entityHit == null || Config.battleModeOnly) {
            return;
        }
        Entity entity2 = entityHit.getEntity();
        if (entity2 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)entity2;
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getEntity() == null || pokemon.getEntity().level().isClientSide || pokemon.getEntity().isBattling()) {
                return;
            }
            if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.heldItem().is(ZCrystals.ULTRANECROZIUM_Z) && UltraLogic.checkFused(pokemon)) {
                boolean enabled;
                if (!UltraLogic.Possible(player)) {
                    return;
                }
                FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("ultra"));
                FlagSpeciesFeature feature = featureProvider.get(pokemon);
                if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
                    new FlagSpeciesFeature("ultra", false).apply(pokemon);
                    Utils.setTradable(pokemon, true);
                    UltraLogic.ultraAnimation((LivingEntity)pokemon.getEntity());
                    return;
                }
                new FlagSpeciesFeature("ultra", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
                UltraLogic.ultraAnimation((LivingEntity)pokemon.getEntity());
            }
        }
    }

    private static boolean checkFused(Pokemon pokemon) {
        boolean enabled;
        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("dusk-fusion"));
        FlagSpeciesFeature feature = featureProvider.get(pokemon);
        if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
            return true;
        }
        featureProvider = new FlagSpeciesFeatureProvider(List.of("dawn-fusion"));
        feature = featureProvider.get(pokemon);
        return feature != null && (enabled = featureProvider.get(pokemon).getEnabled());
    }

    public static void ultraAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityWidth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

