/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public record SoloFusion(List<String> fusions, List<String> pokemons, List<String> mainPokemons, Optional<class_2960> effect, AspectSetCodec aspect_conditions) {
    public static final Codec<SoloFusion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("fusions").forGetter(SoloFusion::fusions), (App)Codec.STRING.listOf().fieldOf("pokemons").forGetter(SoloFusion::pokemons), (App)Codec.STRING.listOf().fieldOf("main_pokemons").forGetter(SoloFusion::mainPokemons), (App)class_2960.field_25139.optionalFieldOf("effect").forGetter(SoloFusion::effect), (App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(SoloFusion::aspect_conditions)).apply((Applicative)instance, SoloFusion::new));

    public class_1271<class_1799> use(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        String namespace = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
        if (level.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        class_3966 hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        class_1297 entity = null;
        if (hitResult != null) {
            entity = hitResult.method_17782();
        }
        class_5455 registryAccess = level.method_30349();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getOwnerPlayer() != player || pokemon.getPersistentData().method_10545("form_changing") || pokemonEntity.getTethering() != null) {
                return class_1271.method_22430((Object)stack);
            }
            boolean isMain = this.mainPokemons.contains(pokemon.getSpecies().getName());
            boolean isFusion = this.pokemons.contains(pokemon.getSpecies().getName());
            if (isMain && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.already_fused").method_27692(class_124.field_1061), true);
                    return class_1271.method_22430((Object)stack);
                }
                if (!this.aspect_conditions.validate_revert(pokemon)) {
                    return class_1271.method_22430((Object)stack);
                }
                Effect.getEffect(this.effect.get()).revertEffects(pokemon, this.aspect_conditions.revert_aspects(), null);
                pokemon.setTradeable(true);
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.method_30349(), pokemon.getPersistentData().method_10562("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                pokemon.getPersistentData().method_10551("fusion_forme");
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + namespace + ".inactive")));
            } else if (pokemonStored != null && isMain) {
                if (!this.aspect_conditions.validate_apply(pokemon)) {
                    return class_1271.method_22430((Object)stack);
                }
                Effect.getEffect(this.effect.get()).revertEffects(pokemon, this.aspect_conditions.apply_aspects(), null);
                pokemon.setTradeable(false);
                class_2487 otherPokemonNbt = pokemonStored.saveToNBT(level.method_30349(), new class_2487());
                pokemon.getPersistentData().method_10566("fusion_pokemon", (class_2520)otherPokemonNbt);
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + namespace + ".inactive")));
            } else if (pokemonStored == null && isFusion) {
                stack.method_57379(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + namespace + ".inactive")));
        }
        return class_1271.method_22430((Object)stack);
    }

    private boolean checkEnabled(Pokemon pokemon) {
        return pokemon.getAspects().stream().anyMatch(this.fusions::contains);
    }

    public void onDestroyed(class_1542 itemEntity) {
        class_1297 class_12972;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.method_6983().method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.method_56673());
        if (pokemonStored != null && (class_12972 = itemEntity.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

