/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class DuFusion
extends ToolTipItem {
    private final List<String> fusions1;
    private final List<String> fusions2;
    private final List<String> pokemons1;
    private final List<String> pokemons2;
    private final List<String> mainPokemons;
    private final String namespace;
    private final List<String> applyAspect1;
    private final List<String> applyAspect2;
    private final List<String> revertAspect1;
    private final List<String> revertAspect2;
    private final String effectId1;
    private final String effectId2;

    public DuFusion(class_1792.class_1793 properties, List<String> fusions1, List<String> fusions2, List<String> pokemons1, List<String> pokemons2, List<String> mainPokemons, List<String> applyAspect1, List<String> applyAspect2, List<String> revertAspect1, List<String> revertAspect2, String effectId1, String effectId2) {
        super(properties);
        this.fusions1 = fusions1;
        this.fusions2 = fusions2;
        this.pokemons1 = pokemons1;
        this.pokemons2 = pokemons2;
        this.mainPokemons = mainPokemons;
        this.applyAspect1 = applyAspect1;
        this.applyAspect2 = applyAspect2;
        this.revertAspect1 = revertAspect1;
        this.revertAspect2 = revertAspect2;
        this.effectId1 = effectId1;
        this.effectId2 = effectId2;
        class_2960 id = class_7923.field_41178.method_10221((Object)this);
        this.namespace = id.method_12836();
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (level.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        class_3966 hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        class_1297 entity = null;
        if (hitResult != null) {
            entity = hitResult.method_17782();
        }
        class_5455 registryAccess = level.method_30349();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getPersistentData().method_10545("form_changing") || pokemonEntity.getTethering() != null) {
                return class_1271.method_22430((Object)stack);
            }
            if (this.mainPokemons.contains(pokemon.getSpecies().getName()) && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.already_fused").method_27692(class_124.field_1061), true);
                    return class_1271.method_22430((Object)stack);
                }
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.method_30349(), pokemon.getPersistentData().method_10562("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                if (this.pokemons1.contains(pokemonInside.getSpecies().getName())) {
                    Effect.getEffect(this.effectId1).revertEffects(pokemon, this.revertAspect1, null);
                } else {
                    Effect.getEffect(this.effectId2).revertEffects(pokemon, this.revertAspect2, null);
                }
                pokemon.setTradeable(true);
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored != null && this.mainPokemons.contains(pokemon.getSpecies().getName())) {
                pokemon.setTradeable(false);
                class_2487 otherPokemonNbt = pokemonStored.saveToNBT(level.method_30349(), new class_2487());
                pokemon.getPersistentData().method_10566("fusion_pokemon", (class_2520)otherPokemonNbt);
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
                pokemon.setTradeable(false);
                if (this.pokemons1.contains(pokemonStored.getSpecies().getName())) {
                    Effect.getEffect(this.effectId1).revertEffects(pokemon, this.applyAspect1, null);
                } else {
                    Effect.getEffect(this.effectId2).revertEffects(pokemon, this.applyAspect2, null);
                }
            } else if (pokemonStored == null && this.pokemons1.contains(pokemon.getSpecies().getName()) || this.pokemons2.contains(pokemon.getSpecies().getName())) {
                stack.method_57379(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
        }
        return class_1271.method_22430((Object)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkEnabled(Pokemon pokemon) {
        if (pokemon.getAspects().stream().anyMatch(this.fusions1::contains)) return true;
        if (!pokemon.getAspects().stream().anyMatch(this.fusions2::contains)) return false;
        return true;
    }

    public void method_33261(class_1542 itemEntity) {
        class_1297 class_12972;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.method_6983().method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.method_56673());
        if (pokemonStored != null && (class_12972 = itemEntity.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

