/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.github.yajatkaul.mega_showdown.utils.AccessoriesUtils;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class GimmickTurnCheck {
    public static void check(class_3222 player) {
        GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
        if (PlayerUtils.isBlockNearby(player, MegaShowdownTags.Blocks.POWER_SPOT, MegaShowdownConfig.powerSpotRange) || MegaShowdownConfig.dynamaxAnywhere) {
            if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.DYNAMAX, player)) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
            }
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.TERASTALLIZATION, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.MEGA_EVOLUTION, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.Z_POWER, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        }
    }

    public static boolean hasGimmick(ShowdownMoveset.Gimmick gimmick, class_3222 player) {
        boolean hasOmniRing = AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.OMNI_RING);
        if (hasOmniRing) {
            return true;
        }
        if (gimmick == ShowdownMoveset.Gimmick.DYNAMAX) {
            if (!MegaShowdownConfig.dynamax) {
                return false;
            }
            return AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.DYNAMAX_BAND);
        }
        if (gimmick == ShowdownMoveset.Gimmick.TERASTALLIZATION) {
            class_1799 teraOrb;
            if (!MegaShowdownConfig.teralization) {
                return false;
            }
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean hasTerapagos = false;
            for (Pokemon pokemon : playerPartyStore) {
                if (!pokemon.getSpecies().getName().equals("Terapagos")) continue;
                hasTerapagos = true;
                break;
            }
            if ((teraOrb = AccessoriesUtils.findFirstItemWithTag((class_1657)player, MegaShowdownTags.Items.TERA_ORB)) == class_1799.field_8037) {
                return false;
            }
            if (hasTerapagos) {
                teraOrb.method_7974(0);
            }
            return teraOrb.method_7919() < 100;
        }
        if (gimmick == ShowdownMoveset.Gimmick.Z_POWER) {
            if (!MegaShowdownConfig.zMoves) {
                return false;
            }
            return AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.Z_RING);
        }
        if (gimmick == ShowdownMoveset.Gimmick.MEGA_EVOLUTION) {
            if (!MegaShowdownConfig.mega) {
                return false;
            }
            return AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET) && !MegaGimmick.hasMega(player);
        }
        return false;
    }
}

