/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.battle.effect;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.github.yajatkaul.mega_showdown.battle.effect.AbstractFieldHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ScalableParticleOptionsBase;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TerrainEffect
extends AbstractFieldHandler {
    public static void handleTerrain(PokemonBattle battle, String terrainName, int ticks) {
        ElementalType type = TerrainEffect.getTypeForTerrain(terrainName);
        if (type == null) {
            return;
        }
        ArrayList<Vec3> pokemonPositions = new ArrayList<Vec3>();
        ServerLevel level = null;
        for (ActiveBattlePokemon pokemon : battle.getActivePokemon()) {
            if (pokemon.getPosition() == null) continue;
            pokemonPositions.add((Vec3)pokemon.getPosition().getSecond());
            level = (ServerLevel)pokemon.getPosition().getFirst();
        }
        if (pokemonPositions.isEmpty() || level == null) {
            return;
        }
        Vec3 centre = pokemonPositions.stream().reduce(Vec3.ZERO, Vec3::add).scale(1.0 / (double)pokemonPositions.size());
        double maxDistance = 0.0;
        for (Vec3 position : pokemonPositions) {
            for (Vec3 otherPosition : pokemonPositions) {
                if (!(position.distanceTo(otherPosition) > maxDistance)) continue;
                maxDistance = position.distanceTo(otherPosition);
            }
        }
        maxDistance += 2.0;
        List<ServerPlayer> players = Stream.concat(battle.getPlayers().stream(), battle.getSpectators().stream().map(arg_0 -> ((ServerLevel)level).getPlayerByUUID(arg_0)).filter(player -> player instanceof ServerPlayer).map(player -> (ServerPlayer)player)).toList();
        int i = 1;
        while ((double)i <= maxDistance) {
            TerrainEffect.createTerrainRing(level, players, centre, i, type);
            ++i;
        }
    }

    @Nullable
    private static ElementalType getTypeForTerrain(String terrain) {
        return switch (terrain) {
            case "mistyterrain" -> ElementalTypes.INSTANCE.getFAIRY();
            case "electricterrain" -> ElementalTypes.INSTANCE.getELECTRIC();
            case "grassyterrain" -> ElementalTypes.INSTANCE.getGRASS();
            case "psychicterrain" -> ElementalTypes.INSTANCE.getPSYCHIC();
            default -> null;
        };
    }

    private static void createTerrainRing(ServerLevel level, List<ServerPlayer> viewers, Vec3 centre, double distance, ElementalType type) {
        for (float i = 0.0f; i < (float)Math.PI * 2; i += (float)Math.PI / (8.0f * (float)distance)) {
            Vec3 particlePos = centre.add((double)Mth.cos((float)i) * distance, 0.0, (double)Mth.sin((float)i) * distance);
            viewers.forEach(viewer -> level.sendParticles(viewer, (ParticleOptions)TerrainEffect.getDustParticleForType(type, 1.5f), false, particlePos.x(), particlePos.y(), particlePos.z(), 1, 0.0, 0.0, 0.0, 0.0));
        }
    }

    static ScalableParticleOptionsBase getDustParticleForType(ElementalType type, float scale) {
        return new DustParticleOptions(Vec3.fromRGB24((int)type.getHue()).toVector3f(), scale);
    }
}

