/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.cobblemon.battle.instruction;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.dispatch.CauserInstruction;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.MoveInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public record MostlyIneffectiveInstruction(BattleMessage message, InstructionSet instructionSet) implements InterpreterInstruction
{
    public void invoke(@NotNull PokemonBattle pokemonBattle) {
        BattlePokemon battlePokemon = this.message.battlePokemon(0, pokemonBattle);
        if (battlePokemon == null) {
            return;
        }
        pokemonBattle.dispatchGo(() -> {
            CauserInstruction lastCauser = this.instructionSet.getMostRecentCauser((InterpreterInstruction)this);
            if (lastCauser instanceof MoveInstruction && !((MoveInstruction)lastCauser).getSpreadTargets().isEmpty()) {
                MutableComponent pokemonName = battlePokemon.getName();
                pokemonBattle.broadcastChatMessage((Component)LocalizationUtilsKt.battleLang((String)"mostlyIneffective_spread", (Object[])new Object[]{pokemonName}).withStyle(ChatFormatting.YELLOW));
            } else {
                pokemonBattle.broadcastChatMessage((Component)LocalizationUtilsKt.battleLang((String)"mostlyIneffective", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW));
            }
            pokemonBattle.getMinorBattleActions().put(battlePokemon.getUuid(), this.message);
            return Unit.INSTANCE;
        });
    }
}

