/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.ShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.HeldItemChangeFormes;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CobbleEventHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Post post) {
        if (post.getReturned() == post.getReceived() || post.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.genesectChange(post);
        HeldItemChangeFormes.silvallyChange(post);
        HeldItemChangeFormes.arcuesChange(post);
        HeldItemChangeFormes.ultraEvent(post);
        HeldItemChangeFormes.primalEvent(post);
        HeldItemChangeFormes.crownedEvent(post);
        HeldItemChangeFormes.ogerponChange(post);
        HeldItemChangeFormes.eternamaxChange(post);
        HeldItemChangeFormes.originChange(post);
        if (ShowdownConfig.battleModeOnly.get().booleanValue()) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.megaEvent(post);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        if (post.getPlayer().method_37908().field_9236) {
            return Unit.INSTANCE;
        }
        if (!post.getPlayer().hasAttached(DataManage.PRIMAL_POKEMON)) {
            post.getPlayer().setAttached(DataManage.PRIMAL_POKEMON, (Object)new Pokemon());
        }
        if (!post.getPlayer().hasAttached(DataManage.MEGA_POKEMON)) {
            post.getPlayer().setAttached(DataManage.MEGA_POKEMON, (Object)new Pokemon());
        }
        if (post.getPlayer().getAttached(DataManage.MEGA_POKEMON) == post.getPokemon()) {
            post.getPlayer().removeAttached(DataManage.MEGA_DATA);
            post.getPlayer().removeAttached(DataManage.MEGA_POKEMON);
        }
        if (post.getPlayer().getAttached(DataManage.PRIMAL_POKEMON) == post.getPokemon()) {
            post.getPlayer().setAttached(DataManage.PRIMAL_DATA, (Object)false);
            post.getPlayer().setAttached(DataManage.PRIMAL_POKEMON, (Object)new Pokemon());
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        class_3222 player = megaEvolutionEvent.getPokemon().getOriginalPokemon().getOwnerPlayer();
        if (player == null) {
            return Unit.INSTANCE;
        }
        MegaLogic.Evolve((class_1309)pokemon.getEntity(), (class_1657)player, true);
        battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)megaEvolutionEvent.getPokemon()).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
        battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != megaEvolutionEvent.getPokemon().getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != megaEvolutionEvent.getPokemon()) continue;
            battle.sendUpdate((NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), megaEvolutionEvent.getPokemon(), true));
        }
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        pokemon.method_6092(new class_1293(class_1294.field_5912, 115, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z_moves");
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(TeraTypeHelper.getGlowColorForType(zMoveUsedEvent.getPokemon().getOriginalPokemon()));
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "terastallized");
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = TeraTypeHelper.getGlowColorForTeraType(terastallizationEvent.getPokemon().getEffectedPokemon().getTeraType());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            if (pk.getSpecies().getName().equals("Ogerpon")) {
                new FlagSpeciesFeature("embody_aspect", true).apply(pk);
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        class_3222 player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        AtomicReference<class_1799> teraOrb = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(TeraMoves.TERA_ORB).forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (!stack.method_7960()) {
                teraOrb.set(stack);
            }
        }));
        if (teraOrb.get() != null) {
            teraOrb.get().method_7974(teraOrb.get().method_7919() + 10);
        }
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        if (!ShowdownConfig.teralization.get().booleanValue() || !(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        class_1792 correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)correspondingTeraShard));
        int randomValue = new Random().nextInt(101);
        if (randomValue >= 10 && randomValue <= 20) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (randomValue == 33) {
            teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)TeraMoves.STELLAR_TERA_SHARD));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        if (pokemonHealedEvent.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        class_3222 player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        AtomicReference<class_1799> teraOrb = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(TeraMoves.TERA_ORB).forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (!stack.method_7960()) {
                teraOrb.set(stack);
            }
        }));
        if (teraOrb != null) {
            teraOrb.get().method_7974(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        PokemonBattle battle = formeChangeEvent.getBattle();
        if (pokemon.getSpecies().getName().equals("Aegislash")) {
            if (formeChangeEvent.getFormeName().equals("blade")) {
                new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("aegislash")) {
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Arceus")) {
            EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
            new StringSpeciesFeature("multitype", formeChangeEvent.getFormeName()).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Minior") && formeChangeEvent.getFormeName().equals("meteor")) {
            EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
            new StringSpeciesFeature("meteor_shield", "core").apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Castform")) {
            if (formeChangeEvent.getFormeName().equals("sunny")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("forecast_form", "sunny").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("rainy")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("forecast_form", "rainy").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("snowy")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("forecast_form", "snowy").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Wishiwashi")) {
            EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
            if (formeChangeEvent.getFormeName().equals("school")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("schooling_form", "school").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("wishiwashi")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Mimikyu")) {
            if (formeChangeEvent.getFormeName().equals("busted")) {
                new StringSpeciesFeature("disguise_form", "busted").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Greninja")) {
            if (formeChangeEvent.getFormeName().equals("ash")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Cherrim")) {
            if (formeChangeEvent.getFormeName().equals("sunshine")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "sunshine").apply(pokemon);
            } else {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Palafin")) {
            if (formeChangeEvent.getFormeName().equals("hero")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("dolphin_form", "hero").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Morpeko")) {
            if (formeChangeEvent.getFormeName().equals("hangry")) {
                EventUtils.playFormeChangeAngryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("hunger_mode", "hangry").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Eiscue")) {
            if (formeChangeEvent.getFormeName().equals("noice")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "noice_face").apply(pokemon);
            } else {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
            }
        } else if (pokemon.getSpecies().getName().equals("Cramorant")) {
            switch (formeChangeEvent.getFormeName()) {
                case "gulping": {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("missile_form", "gulping").apply(pokemon);
                    break;
                }
                case "cramorant": {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("missile_form", "none").apply(pokemon);
                    break;
                }
                case "gorging": {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("missile_form", "gorging").apply(pokemon);
                }
            }
        } else if (pokemon.getSpecies().getName().equals("Darmanitan")) {
            if (formeChangeEvent.getFormeName().equals("zen")) {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "zen").apply(pokemon);
            } else {
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
            }
        }
        battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)formeChangeEvent.getPokemon()).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
        battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != formeChangeEvent.getPokemon().getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != formeChangeEvent.getPokemon()) continue;
            battle.sendUpdate((NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), formeChangeEvent.getPokemon(), true));
        }
        return Unit.INSTANCE;
    }

    public static Unit fixOgerTera(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        }
        return Unit.INSTANCE;
    }
}

