/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.config.ShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ZRingItem;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import kotlin.Unit;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class RevertEvents {
    public static Unit battleStarted(BattleStartedPreEvent battleEvent) {
        for (class_3222 player : battleEvent.getBattle().getPlayers()) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            RevertEvents.checkKeldeo(playerPartyStore);
            if (ShowdownConfig.battleMode.get().booleanValue()) {
                for (Pokemon pokemon : playerPartyStore) {
                    EventUtils.revertFormesEnd(pokemon);
                    if (!pokemon.getAspects().contains("mega-x") && !pokemon.getAspects().contains("mega-y") && !pokemon.getAspects().contains("mega")) continue;
                    MegaLogic.Devolve(pokemon, (class_1657)player, true);
                }
            }
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasTeraItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof TeraItem)).orElse(false);
            if (hasTeraItemTrinkets && ShowdownConfig.teralization.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            }
            if ((ShowdownConfig.scuffedMode.get().booleanValue() || ShowdownConfig.battleMode.get().booleanValue() || ShowdownConfig.battleModeOnly.get().booleanValue()) && MegaLogic.Possible(player, true) && (player.getAttached(DataManage.MEGA_DATA) == null || !((Boolean)player.getAttached(DataManage.MEGA_DATA)).booleanValue())) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            }
            boolean hasZItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof ZRingItem)).orElse(false);
            if ((player.method_6079().method_7909() instanceof ZRingItem || hasZItemTrinkets) && ShowdownConfig.zMoves.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
                continue;
            }
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        }
        return Unit.INSTANCE;
    }

    public static Unit getBattleEndInfo(BattleVictoryEvent battleVictoryEvent) {
        battleVictoryEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon.getAspects().contains("mega-x") || pokemon.getAspects().contains("mega-y") || pokemon.getAspects().contains("mega")) {
                    MegaLogic.Devolve(pokemon, (class_1657)serverPlayer, true);
                }
                EventUtils.revertFormesEnd(pokemon);
                if (pokemon.getEntity() == null) continue;
                pokemon.getEntity().method_6016(class_1294.field_5912);
            }
        });
        return Unit.INSTANCE;
    }

    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        class_3222 serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null || serverPlayer.method_37908().field_9236) {
            return Unit.INSTANCE;
        }
        if (pokemon.getAspects().contains("mega-x") || pokemon.getAspects().contains("mega-y") || pokemon.getAspects().contains("mega")) {
            MegaLogic.Devolve(pokemon, (class_1657)serverPlayer, true);
        }
        return Unit.INSTANCE;
    }

    public static Unit deVolveFlee(BattleFledEvent battleFledEvent) {
        battleFledEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
            for (Pokemon pokemon : playerPartyStore) {
                EventUtils.revertFormesEnd(pokemon);
                if (pokemon.getAspects().contains("mega-x") || pokemon.getAspects().contains("mega-y") || pokemon.getAspects().contains("mega")) {
                    MegaLogic.Devolve(pokemon, (class_1657)serverPlayer, true);
                }
                if (pokemon.getEntity() == null) continue;
                pokemon.getEntity().method_6016(class_1294.field_5912);
            }
        });
        return Unit.INSTANCE;
    }

    private static void checkKeldeo(PlayerPartyStore pokemons) {
        for (Pokemon pokemon : pokemons) {
            if (!pokemon.getSpecies().getName().equals("Keldeo")) continue;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("resolute"));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            boolean hasMove = false;
            for (Move move : pokemon.getMoveSet().getMoves()) {
                if (!move.getName().equals(Moves.INSTANCE.getByName("secretsword").getName())) continue;
                hasMove = true;
            }
            if (pokemon.getAspects().contains("resolute")) {
                if (hasMove) continue;
                new FlagSpeciesFeature("resolute", false).apply(pokemon);
                if (pokemon.getEntity() == null) continue;
                EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
                continue;
            }
            if (!hasMove) continue;
            new FlagSpeciesFeature("resolute", true).apply(pokemon);
            if (pokemon.getEntity() == null) continue;
            EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
        }
    }
}

