/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.mixin;

import com.cobblemon.mod.common.battles.ShowdownThread;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShowdownThread.class})
public class EarlyLoader {
    @Inject(method={"run"}, at={@At(value="HEAD")}, remap=false)
    private void beforeShowdownStarts(CallbackInfo ci) {
        Path showdown_sim = Path.of("./showdown/sim", new String[0]);
        Path showdown_data = Path.of("./showdown/data", new String[0]);
        try {
            Files.createDirectories(showdown_sim, new FileAttribute[0]);
            Files.createDirectories(showdown_data, new FileAttribute[0]);
            this.yoink("/assets/mega_showdown/showdown/moves.js", showdown_data.resolve("moves.js"));
            this.yoink("/assets/mega_showdown/showdown/battle-actions.js", showdown_sim.resolve("battle-actions.js"));
            this.yoink("/assets/mega_showdown/showdown/pokemon.js", showdown_sim.resolve("pokemon.js"));
            this.yoink("/assets/mega_showdown/showdown/abilities.js", showdown_data.resolve("abilities.js"));
            this.yoink("/assets/mega_showdown/showdown/items.js", showdown_data.resolve("items.js"));
            MegaShowdown.LOGGER.info("All files are ready!");
        }
        catch (IOException e) {
            MegaShowdown.LOGGER.error("Failed to prepare required files: {}", (Object)e.getMessage());
        }
    }

    @Unique
    private void yoink(String resourcePath, Path targetPath) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                MegaShowdown.LOGGER.error("Fallback file not found: {}", (Object)resourcePath);
                return;
            }
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            MegaShowdown.LOGGER.info("Loaded fallback file: {}", (Object)targetPath);
        }
        catch (IOException e) {
            MegaShowdown.LOGGER.error("Failed to copy fallback file {}: {}", (Object)resourcePath, (Object)e.getMessage());
        }
    }
}

