/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.client;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.interaction.PokemonInteractionGUICreationEvent;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.gimmick.UltraGimmick;
import com.github.yajatkaul.mega_showdown.networking.server.packet.MegaEvoPacket;
import com.github.yajatkaul.mega_showdown.networking.server.packet.UltraBurstPacket;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.github.yajatkaul.mega_showdown.utils.AccessoriesUtils;
import com.github.yajatkaul.mega_showdown.utils.RegistryLocator;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import kotlin.Unit;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.joml.Vector3f;

public class CobbleClientEvents {
    public static void register() {
        CobblemonEvents.POKEMON_INTERACTION_GUI_CREATION.subscribe(Priority.NORMAL, CobbleClientEvents::addMegaButton);
    }

    private static void addMegaButton(PokemonInteractionGUICreationEvent event) {
        Pokemon pokemon = CobblemonClient.INSTANCE.getStorage().getParty().getSlots().stream().filter(Objects::nonNull).filter(slot -> slot.getEntity() != null && slot.getEntity().method_5667().equals(event.getPokemonID())).findFirst().orElse(null);
        if (pokemon == null) {
            return;
        }
        class_1799 heldItem = pokemon.heldItem();
        class_746 player = class_310.method_1551().field_1724;
        if (MegaShowdownConfig.outSideMega) {
            MegaGimmick megaGimmick = RegistryLocator.getComponent(MegaGimmick.class, heldItem);
            boolean canMega = megaGimmick != null && AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET);
            InteractWheelOption wheelOption = new InteractWheelOption(class_2960.method_60655((String)"mega_showdown", (String)"textures/gui/interact/mega_evolve_wheel.png"), null, canMega, "mega_showdown.ui.mega_evolve", () -> new Vector3f(1.0f), () -> {
                if (canMega) {
                    NetworkManager.sendToServer((class_8710)new MegaEvoPacket(event.getPokemonID()));
                    CobbleClientEvents.closeGUI();
                }
                return Unit.INSTANCE;
            });
            event.addFillingOption(wheelOption);
        }
        if (MegaShowdownConfig.outSideUltraBurst && pokemon.getSpecies().getName().equals("Necrozma")) {
            boolean canUltraBurst = (UltraGimmick.canUltraBurst(pokemon) || pokemon.getAspects().contains("ultra-fusion")) && AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.Z_RING);
            InteractWheelOption wheelOption = new InteractWheelOption(class_2960.method_60655((String)"mega_showdown", (String)"textures/gui/interact/ultra_burst_wheel.png"), null, canUltraBurst, "mega_showdown.ui.ultra_burst", () -> new Vector3f(1.0f), () -> {
                if (canUltraBurst) {
                    NetworkManager.sendToServer((class_8710)new UltraBurstPacket(event.getPokemonID()));
                    CobbleClientEvents.closeGUI();
                }
                return Unit.INSTANCE;
            });
            event.addFillingOption(wheelOption);
        }
    }

    private static void closeGUI() {
        class_310.method_1551().method_1507(null);
    }
}

