/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.github.yajatkaul.mega_showdown.utils.AccessoriesUtils;
import com.github.yajatkaul.mega_showdown.utils.AspectUtils;
import com.github.yajatkaul.mega_showdown.utils.RegistryLocator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public record MegaGimmick(String showdown_id, List<String> pokemons, AspectSetCodec aspect_conditions) {
    public static final Codec<MegaGimmick> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("showdown_id").forGetter(MegaGimmick::showdown_id), (App)Codec.list((Codec)Codec.STRING).fieldOf("pokemons").forGetter(MegaGimmick::pokemons), (App)AspectSetCodec.CODEC.fieldOf("aspect").forGetter(MegaGimmick::aspect_conditions)).apply((Applicative)instance, MegaGimmick::new));
    private static final Set<String> mega_aspects = new HashSet<String>(Set.of("mega", "mega_y", "mega_x"));

    public static void appendMegaAspect(String aspect) {
        mega_aspects.add(aspect);
    }

    public static Set<String> getMegaAspects() {
        return mega_aspects;
    }

    public static boolean hasMega(class_3222 player) {
        if (MegaShowdownConfig.multipleMegas) {
            return false;
        }
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        PCStore pcStore = Cobblemon.INSTANCE.getStorage().getPC(player);
        for (Pokemon pokemon : playerPartyStore) {
            if (!pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) continue;
            return true;
        }
        for (Pokemon pokemon : pcStore) {
            if (!pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) continue;
            return true;
        }
        return false;
    }

    public static void megaEvolveInBattle(Pokemon pokemon, BattlePokemon battlePokemon) {
        class_1799 heldItem = pokemon.heldItem();
        MegaGimmick megaGimmick = RegistryLocator.getComponent(MegaGimmick.class, heldItem);
        if (megaGimmick != null || pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (pokemon.getSpecies().getName().equals("Rayquaza")) {
                Effect.getEffect("mega_showdown:mega_evolution").applyEffectsBattle(pokemon, List.of("mega_evolution=mega"), null, battlePokemon);
                AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), List.of("mega_evolution=none"), pokemon, "battle_end_revert");
            } else if (megaGimmick.canMega(pokemon)) {
                Effect.getEffect("mega_showdown:mega_evolution").applyEffectsBattle(pokemon, megaGimmick.aspect_conditions.apply_aspects(), null, battlePokemon);
                AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), megaGimmick.aspect_conditions.revert_aspects(), pokemon, "battle_end_revert");
            }
        }
    }

    private static void megaEvolve(Pokemon pokemon, List<String> aspects, List<String> revertAspects) {
        Effect.getEffect("mega_showdown:mega_evolution").applyEffects(pokemon, aspects, null);
        AspectUtils.appendRevertDataPokemon(Effect.getEffect("mega_showdown:mega_evolution"), revertAspects, pokemon, "revert_aspects");
        pokemon.setTradeable(false);
    }

    public static void megaToggle(PokemonEntity pokemonEntity) {
        block15: {
            Pokemon pokemon;
            MegaGimmick megaGimmick;
            class_3222 player;
            block14: {
                if (!MegaShowdownConfig.outSideMega || pokemonEntity == null || pokemonEntity.getPokemon().getPersistentData().method_10577("form_changing")) {
                    return;
                }
                player = pokemonEntity.getPokemon().getOwnerPlayer();
                if (player != null && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET) && !AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.OMNI_RING)) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.no_mega_bracelet").method_27692(class_124.field_1061), true);
                    return;
                }
                class_1799 heldItem = pokemonEntity.getPokemon().heldItem();
                megaGimmick = RegistryLocator.getComponent(MegaGimmick.class, heldItem);
                pokemon = pokemonEntity.getPokemon();
                if (megaGimmick != null) break block14;
                if (!pokemon.getSpecies().getName().equals("Rayquaza")) break block15;
            }
            if (pokemon.getAspects().stream().anyMatch(mega_aspects::contains)) {
                if (pokemon.getSpecies().getName().equals("Rayquaza")) {
                    Effect.getEffect("mega_showdown:mega_evolution").revertEffects(pokemon, List.of("mega_evolution=none"), null);
                } else {
                    Effect.getEffect("mega_showdown:mega_evolution").revertEffects(pokemon, megaGimmick.aspect_conditions.revert_aspects(), null);
                }
                pokemon.setTradeable(true);
            } else if (pokemonEntity.getPokemon().getSpecies().getName().equals("Rayquaza")) {
                boolean found = false;
                for (int i = 0; i < 4; ++i) {
                    if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                    MegaGimmick.megaEvolve(pokemon, List.of("mega_evolution=mega"), List.of("mega_evolution=none"));
                    found = true;
                    break;
                }
                if (!found && player != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.rayquaza_no_dragonascent").method_27692(class_124.field_1061), true);
                }
            } else if (megaGimmick.canMega(pokemon)) {
                MegaGimmick.megaEvolve(pokemon, megaGimmick.aspect_conditions.apply_aspects(), megaGimmick.aspect_conditions.revert_aspects());
            }
        }
    }

    public boolean canMega(Pokemon pokemon) {
        class_3222 player = pokemon.getOwnerPlayer();
        if (player != null && MegaGimmick.hasMega(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.mega_limit").method_27692(class_124.field_1061), true);
            return false;
        }
        if (!this.aspect_conditions.validate_apply(pokemon)) {
            return false;
        }
        return this.pokemons.contains(pokemon.getSpecies().getName());
    }
}

