/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.networking.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.gimmick.UltraGimmick;
import com.github.yajatkaul.mega_showdown.networking.server.packet.MegaEvoPacket;
import com.github.yajatkaul.mega_showdown.networking.server.packet.SecretSwordMoveSwapPacket;
import com.github.yajatkaul.mega_showdown.networking.server.packet.UltraBurstPacket;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class MegaShowdownNetworkHandlerServer {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, MegaEvoPacket.TYPE, MegaEvoPacket.STREAM_CODEC, (buf, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            Pokemon pokemon = PlayerUtils.getPartyPokemonFromUUID(player, buf.pokemonId());
            if (pokemon != null) {
                MegaGimmick.megaToggle(pokemon.getEntity());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UltraBurstPacket.TYPE, UltraBurstPacket.STREAM_CODEC, (buf, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            Pokemon pokemon = PlayerUtils.getPartyPokemonFromUUID(player, buf.pokemonId());
            if (pokemon != null) {
                UltraGimmick.ultraBurstToggle(pokemon);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SecretSwordMoveSwapPacket.TYPE, SecretSwordMoveSwapPacket.STREAM_CODEC, (buf, context) -> {
            class_1657 player = context.getPlayer();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                    if (!pokemon.getSpecies().getName().equals("Keldeo")) continue;
                    boolean hasSecretSword = pokemon.getMoveSet().getMoves().stream().anyMatch(move -> move.getTemplate().getName().equals("secretsword"));
                    boolean isResolute = pokemon.getAspects().contains("resolute-form");
                    if (!isResolute && hasSecretSword) {
                        Effect.getEffect("mega_showdown:keldeo_effect").applyEffects(pokemon, List.of("sword_form=resolute"), null);
                        continue;
                    }
                    if (!isResolute || hasSecretSword) continue;
                    Effect.getEffect("mega_showdown:keldeo_effect").revertEffects(pokemon, List.of("sword_form=ordinary"), null);
                }
            }
        });
    }
}

