/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.config;

import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class MegaShowdownConfig {
    private static final String FILE_PATH = "./config/mega_showdown/config.json";
    public static boolean loaded = false;
    public static int teraShardRequired = 50;
    public static boolean outSideMega = true;
    public static boolean outSideUltraBurst = false;
    public static boolean multipleMegas = false;
    public static boolean showdownFilesLoading = true;
    public static boolean mega = true;
    public static boolean zMoves = true;
    public static boolean teralization = true;
    public static boolean dynamax = true;
    public static int powerSpotRange = 20;
    public static boolean dynamaxAnywhere = false;
    public static float dynamaxScaleFactor = 4.0f;
    public static double teraShardDropRate = 10.0;
    public static double stellarShardDropRate = 1.0;
    public static int likoPendentDuration = 72000;
    public static int minBondingRequired = 200;

    private static void save() {
        JsonObject json = MegaShowdownConfig.getJsonObject();
        try {
            Files.createDirectories(Path.of("./config/mega_showdown", new String[0]), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(FILE_PATH);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson((JsonElement)json));
            }
        }
        catch (IOException e) {
            MegaShowdown.LOGGER.error("Failed to save MegaShowdown config:", (Throwable)e);
        }
    }

    @NotNull
    private static JsonObject getJsonObject() {
        JsonObject json = new JsonObject();
        json.addProperty("teraShardRequired", (Number)teraShardRequired);
        json.addProperty("multipleMegas", Boolean.valueOf(multipleMegas));
        json.addProperty("showdownFilesLoading", Boolean.valueOf(showdownFilesLoading));
        json.addProperty("mega", Boolean.valueOf(mega));
        json.addProperty("zMoves", Boolean.valueOf(zMoves));
        json.addProperty("teralization", Boolean.valueOf(teralization));
        json.addProperty("dynamax", Boolean.valueOf(dynamax));
        json.addProperty("powerSpotRange", (Number)powerSpotRange);
        json.addProperty("dynamaxAnywhere", Boolean.valueOf(dynamaxAnywhere));
        json.addProperty("dynamaxScaleFactor", (Number)Float.valueOf(dynamaxScaleFactor));
        json.addProperty("teraShardDropRate", (Number)teraShardDropRate);
        json.addProperty("stellarShardDropRate", (Number)stellarShardDropRate);
        json.addProperty("likoPendentDuration", (Number)likoPendentDuration);
        json.addProperty("minBondingRequired", (Number)minBondingRequired);
        json.addProperty("outSideMega", Boolean.valueOf(outSideMega));
        json.addProperty("outSideUltraBurst", Boolean.valueOf(outSideUltraBurst));
        return json;
    }

    public static void load() {
        File file = new File(FILE_PATH);
        if (!file.exists()) {
            MegaShowdown.LOGGER.info("MegaShowdown config not found, creating default.");
            MegaShowdownConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Gson gson = new Gson();
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (json.has("teraShardRequired")) {
                teraShardRequired = json.get("teraShardRequired").getAsInt();
            }
            if (json.has("multipleMegas")) {
                multipleMegas = json.get("multipleMegas").getAsBoolean();
            }
            if (json.has("showdownFilesLoading")) {
                showdownFilesLoading = json.get("showdownFilesLoading").getAsBoolean();
            }
            if (json.has("mega")) {
                mega = json.get("mega").getAsBoolean();
            }
            if (json.has("zMoves")) {
                zMoves = json.get("zMoves").getAsBoolean();
            }
            if (json.has("teralization")) {
                teralization = json.get("teralization").getAsBoolean();
            }
            if (json.has("dynamax")) {
                dynamax = json.get("dynamax").getAsBoolean();
            }
            if (json.has("powerSpotRange")) {
                powerSpotRange = json.get("powerSpotRange").getAsInt();
            }
            if (json.has("dynamaxAnywhere")) {
                dynamaxAnywhere = json.get("dynamaxAnywhere").getAsBoolean();
            }
            if (json.has("dynamaxScaleFactor")) {
                dynamaxScaleFactor = json.get("dynamaxScaleFactor").getAsFloat();
            }
            if (json.has("teraShardDropRate")) {
                teraShardDropRate = json.get("teraShardDropRate").getAsDouble();
            }
            if (json.has("stellarShardDropRate")) {
                stellarShardDropRate = json.get("stellarShardDropRate").getAsDouble();
            }
            if (json.has("likoPendentDuration")) {
                likoPendentDuration = json.get("likoPendentDuration").getAsInt() * 20;
            }
            if (json.has("minBondingRequired")) {
                minBondingRequired = json.get("minBondingRequired").getAsInt();
            }
            if (json.has("outSideMega")) {
                outSideMega = json.get("outSideMega").getAsBoolean();
            }
            if (json.has("outSideUltraBurst")) {
                outSideUltraBurst = json.get("outSideUltraBurst").getAsBoolean();
            }
        }
        catch (Exception e) {
            MegaShowdown.LOGGER.error("Failed to load MegaShowdown config:", (Throwable)e);
        }
        loaded = true;
    }

    public static int getDynamaxScaleDuration() {
        return (int)(dynamaxScaleFactor / 0.1f);
    }
}

