/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public record DuFusion(List<String> fusions1, List<String> fusions2, List<String> pokemons1, AspectSetCodec pokemon_1_aspect_conditions, List<String> pokemons2, AspectSetCodec pokemon_2_aspect_conditions, List<String> mainPokemons, AspectSetCodec pokemon_main_aspect_conditions, Optional<ResourceLocation> effect1, Optional<ResourceLocation> effect2) {
    public static final Codec<DuFusion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("fusions1").forGetter(DuFusion::fusions1), (App)Codec.STRING.listOf().fieldOf("fusions2").forGetter(DuFusion::fusions2), (App)Codec.STRING.listOf().fieldOf("pokemons1").forGetter(DuFusion::pokemons1), (App)AspectSetCodec.CODEC.fieldOf("pokemon_1_aspect_conditions").forGetter(DuFusion::pokemon_1_aspect_conditions), (App)Codec.STRING.listOf().fieldOf("pokemons2").forGetter(DuFusion::pokemons2), (App)AspectSetCodec.CODEC.fieldOf("pokemon_2_aspect_conditions").forGetter(DuFusion::pokemon_1_aspect_conditions), (App)Codec.STRING.listOf().fieldOf("main_pokemons").forGetter(DuFusion::mainPokemons), (App)AspectSetCodec.CODEC.fieldOf("pokemon_main_aspect_conditions").forGetter(DuFusion::pokemon_1_aspect_conditions), (App)ResourceLocation.CODEC.optionalFieldOf("effect_for_fusion1").forGetter(DuFusion::effect1), (App)ResourceLocation.CODEC.optionalFieldOf("effect_for_fusion2").forGetter(DuFusion::effect2)).apply((Applicative)instance, DuFusion::new));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        String namespace = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        Entity entity = null;
        if (hitResult != null) {
            entity = hitResult.getEntity();
        }
        RegistryAccess registryAccess = level.registryAccess();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getOwnerPlayer() != player || pokemon.getPersistentData().contains("form_changing") || pokemonEntity.getTethering() != null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (this.mainPokemons.contains(pokemon.getSpecies().getName()) && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.registryAccess(), pokemon.getPersistentData().getCompound("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                if (this.pokemons1.contains(pokemonInside.getSpecies().getName()) && this.pokemon_1_aspect_conditions.validate_revert(pokemon)) {
                    Effect.getEffect(this.effect1.get()).revertEffects(pokemon, this.pokemon_1_aspect_conditions.revert_aspects(), null);
                } else {
                    if (!this.pokemon_2_aspect_conditions.validate_revert(pokemon)) return InteractionResultHolder.pass((Object)stack);
                    Effect.getEffect(this.effect2.get()).revertEffects(pokemon, this.pokemon_2_aspect_conditions.revert_aspects(), null);
                }
                pokemon.setTradeable(true);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
                return InteractionResultHolder.pass((Object)stack);
            } else if (pokemonStored != null && this.mainPokemons.contains(pokemon.getSpecies().getName())) {
                pokemon.setTradeable(false);
                CompoundTag otherPokemonNbt = pokemonStored.saveToNBT(level.registryAccess(), new CompoundTag());
                pokemon.getPersistentData().put("fusion_pokemon", (Tag)otherPokemonNbt);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
                pokemon.setTradeable(false);
                if (this.pokemons1.contains(pokemonStored.getSpecies().getName()) && this.pokemon_1_aspect_conditions.validate_apply(pokemon)) {
                    Effect.getEffect(this.effect1.get()).applyEffects(pokemon, this.pokemon_1_aspect_conditions.apply_aspects(), null);
                    return InteractionResultHolder.pass((Object)stack);
                } else {
                    if (!this.pokemon_2_aspect_conditions.validate_apply(pokemon)) return InteractionResultHolder.pass((Object)stack);
                    Effect.getEffect(this.effect1.get()).applyEffects(pokemon, this.pokemon_2_aspect_conditions.apply_aspects(), null);
                }
                return InteractionResultHolder.pass((Object)stack);
            } else {
                if ((pokemonStored != null || !this.pokemons1.contains(pokemon.getSpecies().getName())) && !this.pokemons2.contains(pokemon.getSpecies().getName())) return InteractionResultHolder.pass((Object)stack);
                stack.set(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
            return InteractionResultHolder.pass((Object)stack);
        } else {
            if (pokemonStored == null) return InteractionResultHolder.pass((Object)stack);
            playerPartyStore.add(pokemonStored);
            stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkEnabled(Pokemon pokemon) {
        if (pokemon.getAspects().stream().anyMatch(this.fusions1::contains)) return true;
        if (!pokemon.getAspects().stream().anyMatch(this.fusions2::contains)) return false;
        return true;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        Entity entity;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.getItem().getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.registryAccess());
        if (pokemonStored != null && (entity = itemEntity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

