/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record FormChangeInteractItem(AspectSetCodec aspect_conditions, List<String> pokemons, Optional<ResourceLocation> effect, int consume) {
    public static final Codec<FormChangeInteractItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(FormChangeInteractItem::aspect_conditions), (App)Codec.STRING.listOf().fieldOf("pokemons").forGetter(FormChangeInteractItem::pokemons), (App)ResourceLocation.CODEC.optionalFieldOf("effect").forGetter(FormChangeInteractItem::effect), (App)Codec.INT.optionalFieldOf("consume", (Object)0).forGetter(FormChangeInteractItem::consume)).apply((Applicative)instance, FormChangeInteractItem::new));

    public InteractionResult interactLivingEntity(Player player, LivingEntity livingEntity, ItemStack stack) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (livingEntity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (!this.pokemons.contains(pokemon.getSpecies().getName()) || pokemon.getOwnerPlayer() != player || pokemonEntity.isBattling() || pokemonEntity.getTethering() != null || pokemon.getPersistentData().contains("form_changing")) {
                return InteractionResult.PASS;
            }
            if (this.aspect_conditions.validate_apply(pokemon)) {
                Effect.getEffect(this.effect.get()).applyEffects(pokemon, this.aspect_conditions.apply_aspects(), null);
                stack.consume(this.consume, livingEntity);
                return InteractionResult.SUCCESS;
            }
            if (this.aspect_conditions.validate_revert(pokemon)) {
                Effect.getEffect(this.effect.get()).applyEffects(pokemon, this.aspect_conditions.revert_aspects(), null);
                stack.consume(this.consume, livingEntity);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

