/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public record SoloFusion(List<String> fusions, List<String> pokemons, List<String> mainPokemons, Optional<ResourceLocation> effect, AspectSetCodec aspect_conditions) {
    public static final Codec<SoloFusion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("fusions").forGetter(SoloFusion::fusions), (App)Codec.STRING.listOf().fieldOf("pokemons").forGetter(SoloFusion::pokemons), (App)Codec.STRING.listOf().fieldOf("main_pokemons").forGetter(SoloFusion::mainPokemons), (App)ResourceLocation.CODEC.optionalFieldOf("effect").forGetter(SoloFusion::effect), (App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(SoloFusion::aspect_conditions)).apply((Applicative)instance, SoloFusion::new));

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        String namespace = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        Entity entity = null;
        if (hitResult != null) {
            entity = hitResult.getEntity();
        }
        RegistryAccess registryAccess = level.registryAccess();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getOwnerPlayer() != player || pokemon.getPersistentData().contains("form_changing") || pokemonEntity.getTethering() != null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            boolean isMain = this.mainPokemons.contains(pokemon.getSpecies().getName());
            boolean isFusion = this.pokemons.contains(pokemon.getSpecies().getName());
            if (isMain && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                if (!this.aspect_conditions.validate_revert(pokemon)) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                Effect.getEffect(this.effect.get()).revertEffects(pokemon, this.aspect_conditions.revert_aspects(), null);
                pokemon.setTradeable(true);
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.registryAccess(), pokemon.getPersistentData().getCompound("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                pokemon.getPersistentData().remove("fusion_forme");
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
            } else if (pokemonStored != null && isMain) {
                if (!this.aspect_conditions.validate_apply(pokemon)) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                Effect.getEffect(this.effect.get()).revertEffects(pokemon, this.aspect_conditions.apply_aspects(), null);
                pokemon.setTradeable(false);
                CompoundTag otherPokemonNbt = pokemonStored.saveToNBT(level.registryAccess(), new CompoundTag());
                pokemon.getPersistentData().put("fusion_pokemon", (Tag)otherPokemonNbt);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
            } else if (pokemonStored == null && isFusion) {
                stack.set(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + namespace + ".inactive")));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean checkEnabled(Pokemon pokemon) {
        return pokemon.getAspects().stream().anyMatch(this.fusions::contains);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        Entity entity;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.getItem().getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.registryAccess());
        if (pokemonStored != null && (entity = itemEntity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

