/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AshCap
extends PokemonSelectingItem {
    public AshCap(Item.Properties arg) {
        super(arg);
    }

    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getName().equals("Greninja") && !pokemon.getAspects().contains("bond");
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer serverPlayer, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (pokemon.getFriendship() < MegaShowdownConfig.minBondingRequired) {
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.friendship_requirement").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Effect.getEffect("mega_showdown:heart_effect").applyEffects(pokemon, List.of("battle_bond=bond"), null);
        AdvancementHelper.grantAdvancement(serverPlayer, "bond/ash_cap_bond");
        itemStack.consume(1, (LivingEntity)serverPlayer);
        return InteractionResultHolder.success((Object)itemStack);
    }
}

