/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipBlockItem;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RotomUnitItem
extends ToolTipBlockItem {
    private static final List<String> rotomAspects = List.of("heat-appliance", "wash-appliance", "mow-appliance", "frost-appliance", "fan-appliance");
    private final String form;

    public RotomUnitItem(Block block, Item.Properties properties, String form) {
        super(block, properties);
        this.form = form;
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        block4: {
            Pokemon pokemon;
            block6: {
                block5: {
                    if (player.level().isClientSide || player.isCrouching()) {
                        return InteractionResult.PASS;
                    }
                    if (!(livingEntity instanceof PokemonEntity)) break block4;
                    PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
                    pokemon = pokemonEntity.getPokemon();
                    if (!pokemon.getSpecies().getName().equals("Rotom")) break block5;
                    if (!pokemon.getAspects().stream().anyMatch(rotomAspects::contains)) break block6;
                }
                return InteractionResult.PASS;
            }
            Effect.getEffect("mega_showdown:rotom_" + this.form + "_effect").applyEffects(pokemon, List.of(String.format("appliance=%s", this.form)), null);
            itemStack.consume(1, (LivingEntity)player);
            AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

