/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlocks;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.InventoryStorage;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.screen.custom.ZygardeCubesScreenHandler;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ZygardeCube
extends ToolTipItem {
    public ZygardeCube(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide || player.isCrouching()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        Entity entity = null;
        if (hitResult != null) {
            entity = hitResult.getEntity();
        }
        RegistryAccess registryAccess = level.registryAccess();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon storedPokemon = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemonEntity.getTethering() != null || pokemon.getPersistentData().contains("form_changing")) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (pokemon.getAspects().contains("core-percent")) {
                InventoryStorage inventoryStorage = (InventoryStorage)stack.getOrDefault(MegaShowdownDataComponents.INVENTORY.get(), (Object)InventoryStorage.defaultStorage(2));
                SimpleContainer inventory = inventoryStorage.getInventory((HolderLookup.Provider)registryAccess);
                if (inventory.getItem(1).getCount() >= 5) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.cube_core_full").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                int count = inventory.getItem(1).getCount() + 1;
                ItemStack newStack = new ItemStack((ItemLike)MegaShowdownItems.ZYGARDE_CORE.get(), count);
                inventory.setItem(1, newStack);
                stack.set(MegaShowdownDataComponents.INVENTORY.get(), (Object)inventoryStorage.save((HolderLookup.Provider)registryAccess, inventory));
                if (pokemon.isPlayerOwned()) {
                    Cobblemon.INSTANCE.getStorage().getParty(pokemon.getOwnerPlayer()).remove(pokemon);
                } else {
                    entity.discard();
                }
                return InteractionResultHolder.success((Object)stack);
            }
            if (pokemon.getOwnerPlayer() != player) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (pokemon.getSpecies().getName().equals("Zygarde")) {
                if (!pokemon.getAspects().contains("power-construct")) {
                    if (storedPokemon != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.cube_full").withStyle(ChatFormatting.RED), true);
                        return InteractionResultHolder.pass((Object)stack);
                    }
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube.full"));
                    stack.set(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                    playerPartyStore.remove(pokemon);
                    return InteractionResultHolder.success((Object)stack);
                }
                if (pokemon.getAspects().contains("10-percent")) {
                    Effect.getEffect("mega_showdown:end_rod").applyEffects(pokemon, List.of("percent_cells=50"), null);
                    return InteractionResultHolder.success((Object)stack);
                }
                if (pokemon.getAspects().contains("50-percent")) {
                    Effect.getEffect("mega_showdown:end_rod").applyEffects(pokemon, List.of("percent_cells=10"), null);
                    return InteractionResultHolder.success((Object)stack);
                }
            }
        } else {
            BlockHitResult blockHitResult = PlayerUtils.getBlockLookingAt(player, 4.5f);
            if (storedPokemon != null) {
                playerPartyStore.add(storedPokemon);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube.empty"));
                return InteractionResultHolder.success((Object)stack);
            }
            if (blockHitResult.getType() == HitResult.Type.BLOCK && level.getBlockState(blockHitResult.getBlockPos()).is((Block)MegaShowdownBlocks.REASSEMBLY_UNIT.get())) {
                return InteractionResultHolder.pass((Object)stack);
            }
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new ZygardeCubesScreenHandler(id, playerInventory, stack, level), (Component)Component.translatable((String)"menu.zygade_cube")));
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

