/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class SoloFusion
extends ToolTipItem {
    private final List<String> fusions;
    private final List<String> pokemons;
    private final List<String> mainPokemons;
    private final String namespace;
    private final String effectId;
    private final List<String> applyAspect;
    private final List<String> revertAspect;

    public SoloFusion(Item.Properties properties, List<String> fusions, List<String> pokemons, List<String> mainPokemons, String effectId, List<String> applyAspect, List<String> revertAspect) {
        super(properties);
        this.fusions = fusions;
        this.pokemons = pokemons;
        this.mainPokemons = mainPokemons;
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this);
        this.namespace = id.getNamespace();
        this.effectId = effectId;
        this.applyAspect = applyAspect;
        this.revertAspect = revertAspect;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        Entity entity = null;
        if (hitResult != null) {
            entity = hitResult.getEntity();
        }
        RegistryAccess registryAccess = level.registryAccess();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getPersistentData().contains("form_changing") || pokemonEntity.getTethering() != null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            boolean isMain = this.mainPokemons.contains(pokemon.getSpecies().getName());
            boolean isFusion = this.pokemons.contains(pokemon.getSpecies().getName());
            if (isMain && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                Effect.getEffect(this.effectId).revertEffects(pokemon, this.revertAspect, null);
                pokemon.setTradeable(true);
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.registryAccess(), pokemon.getPersistentData().getCompound("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                pokemon.getPersistentData().remove("fusion_forme");
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored != null && isMain) {
                Effect.getEffect(this.effectId).revertEffects(pokemon, this.applyAspect, null);
                pokemon.setTradeable(false);
                CompoundTag otherPokemonNbt = pokemonStored.saveToNBT(level.registryAccess(), new CompoundTag());
                pokemon.getPersistentData().put("fusion_pokemon", (Tag)otherPokemonNbt);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored == null && isFusion) {
                stack.set(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean checkEnabled(Pokemon pokemon) {
        return pokemon.getAspects().stream().anyMatch(this.fusions::contains);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        Entity entity;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.getItem().getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.registryAccess());
        if (pokemonStored != null && (entity = itemEntity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

