/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class DuFusion
extends ToolTipItem {
    private final List<String> fusions1;
    private final List<String> fusions2;
    private final List<String> pokemons1;
    private final List<String> pokemons2;
    private final List<String> mainPokemons;
    private final String namespace;
    private final List<String> applyAspect1;
    private final List<String> applyAspect2;
    private final List<String> revertAspect1;
    private final List<String> revertAspect2;
    private final String effectId1;
    private final String effectId2;

    public DuFusion(Item.Properties properties, List<String> fusions1, List<String> fusions2, List<String> pokemons1, List<String> pokemons2, List<String> mainPokemons, List<String> applyAspect1, List<String> applyAspect2, List<String> revertAspect1, List<String> revertAspect2, String effectId1, String effectId2, String namespace) {
        super(properties);
        this.fusions1 = fusions1;
        this.fusions2 = fusions2;
        this.pokemons1 = pokemons1;
        this.pokemons2 = pokemons2;
        this.mainPokemons = mainPokemons;
        this.applyAspect1 = applyAspect1;
        this.applyAspect2 = applyAspect2;
        this.revertAspect1 = revertAspect1;
        this.revertAspect2 = revertAspect2;
        this.effectId1 = effectId1;
        this.effectId2 = effectId2;
        this.namespace = namespace;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        EntityHitResult hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        Entity entity = null;
        if (hitResult != null) {
            entity = hitResult.getEntity();
        }
        RegistryAccess registryAccess = level.registryAccess();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemonEntity.isBattling() || pokemon.getPersistentData().contains("form_changing") || pokemonEntity.getTethering() != null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (this.mainPokemons.contains(pokemon.getSpecies().getName()) && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.registryAccess(), pokemon.getPersistentData().getCompound("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                if (this.pokemons1.contains(pokemonInside.getSpecies().getName())) {
                    Effect.getEffect(this.effectId1).revertEffects(pokemon, this.revertAspect1, null);
                } else {
                    Effect.getEffect(this.effectId2).revertEffects(pokemon, this.revertAspect2, null);
                }
                pokemon.setTradeable(true);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored != null && this.mainPokemons.contains(pokemon.getSpecies().getName())) {
                pokemon.setTradeable(false);
                CompoundTag otherPokemonNbt = pokemonStored.saveToNBT(level.registryAccess(), new CompoundTag());
                pokemon.getPersistentData().put("fusion_pokemon", (Tag)otherPokemonNbt);
                stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
                pokemon.setTradeable(false);
                if (this.pokemons1.contains(pokemonStored.getSpecies().getName())) {
                    Effect.getEffect(this.effectId1).revertEffects(pokemon, this.applyAspect1, null);
                } else {
                    Effect.getEffect(this.effectId2).revertEffects(pokemon, this.applyAspect2, null);
                }
            } else if (pokemonStored == null && this.pokemons1.contains(pokemon.getSpecies().getName()) || this.pokemons2.contains(pokemon.getSpecies().getName())) {
                stack.set(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.remove(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.mega_showdown." + this.namespace + ".inactive")));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkEnabled(Pokemon pokemon) {
        if (pokemon.getAspects().stream().anyMatch(this.fusions1::contains)) return true;
        if (!pokemon.getAspects().stream().anyMatch(this.fusions2::contains)) return false;
        return true;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        Entity entity;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.getItem().getOrDefault(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.registryAccess());
        if (pokemonStored != null && (entity = itemEntity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

