/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.ShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.ZMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ZRingItem;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5251;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class CobbleEventHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Post post) {
        if (post.getReturned() == post.getReceived() || post.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        CobbleEventHandler.checkUltra(post);
        CobbleEventHandler.primalEvent(post);
        CobbleEventHandler.crownedEvent(post);
        CobbleEventHandler.ogerponChange(post);
        CobbleEventHandler.eternamaxChange(post);
        CobbleEventHandler.originChange(post);
        if (ShowdownConfig.battleModeOnly.get().booleanValue()) {
            return Unit.INSTANCE;
        }
        CobbleEventHandler.megaEvent(post);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        if (post.getPlayer().method_37908().field_9236) {
            return Unit.INSTANCE;
        }
        if (!post.getPlayer().hasAttached(DataManage.PRIMAL_POKEMON)) {
            post.getPlayer().setAttached(DataManage.PRIMAL_POKEMON, (Object)new Pokemon());
        }
        if (!post.getPlayer().hasAttached(DataManage.MEGA_POKEMON)) {
            post.getPlayer().setAttached(DataManage.MEGA_POKEMON, (Object)new Pokemon());
        }
        if (post.getPlayer().getAttached(DataManage.MEGA_POKEMON) == post.getPokemon()) {
            post.getPlayer().removeAttached(DataManage.MEGA_DATA);
            post.getPlayer().removeAttached(DataManage.MEGA_POKEMON);
        }
        if (post.getPlayer().getAttached(DataManage.PRIMAL_POKEMON) == post.getPokemon()) {
            post.getPlayer().setAttached(DataManage.PRIMAL_DATA, (Object)false);
            post.getPlayer().setAttached(DataManage.PRIMAL_POKEMON, (Object)new Pokemon());
        }
        return Unit.INSTANCE;
    }

    public static void originChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (post.getReceived().method_31574(ModItems.GRISEOUS_ORB)) {
                CobbleEventHandler.originAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("orb_forme", "origin").apply(pokemon);
                MegaShowdown.LOGGER.info(pokemon.getAspects().toString());
            } else {
                CobbleEventHandler.originAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("orb_forme", "altered").apply(pokemon);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Post post) {
        if (!ShowdownConfig.etermaxForme.get().booleanValue()) {
            return;
        }
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Eternatus") && post.getReceived().method_31574(ModItems.STAR_CORE)) {
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
        } else if (pokemon.getSpecies().getName().equals("Eternatus")) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
        }
    }

    public static void ogerponChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (post.getReceived().method_31574(ModItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getFIRE());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().method_31574(ModItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getGROUND());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().method_31574(ModItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getWATER());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            try {
                pokemon.setTeraType(TeraTypes.getGRASS());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        }
    }

    public static void primalEvent(HeldItemEvent.Post post) {
        class_3222 player = post.getPokemon().getOwnerPlayer();
        Species species = post.getPokemon().getSpecies();
        if (species.getName().equals(Utils.getSpecies("kyogre").getName()) && post.getReceived().method_31574(MegaStones.BLUE_ORB)) {
            if (((Boolean)player.getAttached(DataManage.PRIMAL_DATA)).booleanValue() && !ShowdownConfig.multiplePrimals.get().booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You can only have one primal at a time").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            new FlagSpeciesFeature("primal", true).apply(post.getPokemon());
            Utils.setTradable(post.getPokemon(), false);
            CobbleEventHandler.primalRevertAnimation((class_1309)post.getPokemon().getEntity(), class_2398.field_11247);
            AdvancementHelper.grantAdvancement(player, "primal_evo");
            player.setAttached(DataManage.PRIMAL_DATA, (Object)true);
        } else if (species.getName().equals(Utils.getSpecies("groudon").getName()) && post.getReceived().method_31574(MegaStones.RED_ORB)) {
            if (((Boolean)player.getAttached(DataManage.PRIMAL_DATA)).booleanValue() && !ShowdownConfig.multiplePrimals.get().booleanValue()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You can only have one primal at a time").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            new FlagSpeciesFeature("primal", true).apply(post.getPokemon());
            Utils.setTradable(post.getPokemon(), false);
            CobbleEventHandler.primalRevertAnimation((class_1309)post.getPokemon().getEntity(), class_2398.field_17430);
            AdvancementHelper.grantAdvancement(player, "primal_evo");
            player.setAttached(DataManage.PRIMAL_DATA, (Object)true);
        } else {
            SpeciesFeature feature = post.getPokemon().getFeature("primal");
            if (feature == null) {
                return;
            }
            new FlagSpeciesFeature("primal", false).apply(post.getPokemon());
            Utils.setTradable(post.getPokemon(), true);
            CobbleEventHandler.primalRevertAnimation((class_1309)post.getPokemon().getEntity(), class_2398.field_11207);
            player.setAttached(DataManage.PRIMAL_DATA, (Object)false);
        }
    }

    public static void megaEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getEntity() == null) {
            return;
        }
        if (pokemon.getEntity().method_37908().field_9236) {
            return;
        }
        Species species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().method_7909());
        List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
        for (String key : megaKeys) {
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
            class_3222 player = pokemon.getOwnerPlayer();
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature == null) continue;
            boolean enabled = featureProvider.get(pokemon).getEnabled();
            if (enabled && feature.getName().equals("mega") && (species != pokemon.getSpecies() || event.getReceived() != event.getReturned())) {
                MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)player);
                continue;
            }
            if (enabled && feature.getName().equals("mega-x") && (species != pokemon.getSpecies() || event.getReceived() != event.getReturned())) {
                MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)player);
                continue;
            }
            if (!enabled || !feature.getName().equals("mega-y") || species == pokemon.getSpecies() && event.getReceived() == event.getReturned()) continue;
            MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)player);
        }
    }

    public static void crownedEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceived().method_31574(ModItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                CobbleEventHandler.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (event.getReceived().method_31574(ModItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                CobbleEventHandler.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturned().method_31574(ModItems.RUSTED_SWORD)) {
                CobbleEventHandler.playEvolveAnimation((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturned().method_31574(ModItems.RUSTED_SHIELD)) {
                CobbleEventHandler.playEvolveAnimation((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            }
        }
    }

    public static void checkUltra(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && event.getReturned().method_31574(ZMoves.ULTRANECROZIUM_Z)) {
            CobbleEventHandler.ultraAnimation((class_1309)pokemon.getEntity());
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        }
    }

    public static void ultraAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_14703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverWorld.method_14199((class_2394)class_2398.field_28479, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void crownAnimation(class_3218 level, class_2338 pos, class_1309 context) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)level);
        if (lightning != null) {
            lightning.method_33574(class_243.method_24955((class_2382)pos));
            lightning.method_29498(true);
            level.method_8649((class_1297)lightning);
            CobbleEventHandler.playEvolveAnimation(context);
        }
    }

    public static void playEvolveAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_26980, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void primalRevertAnimation(class_1309 context, class_2400 particleType) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_14703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverWorld.method_14199((class_2394)particleType, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void originAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double entityDepth = entityWidth;
            double scaleFactor = 4.0;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverWorld.method_60511(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, (class_6880)class_3417.field_41703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverWorld.method_14199((class_2394)class_2398.field_22247, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static Unit getBattleEndInfo(BattleVictoryEvent battleVictoryEvent) {
        battleVictoryEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon.getEntity() == null) continue;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
                pokemon.getEntity().method_6016(class_1294.field_5912);
            }
            block1: for (BattlePokemon battlePokemon : battleVictoryEvent.getBattle().getActor(serverPlayer.method_5667()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null || battlePokemon.getOriginalPokemon().getEntity().method_37908().field_9236) continue;
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                for (String key : megaKeys) {
                    boolean enabled;
                    FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                    FlagSpeciesFeature feature = featureProvider.get(pokemon);
                    if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                    MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)serverPlayer);
                    if (ShowdownConfig.multipleMegas.get().booleanValue()) continue;
                    continue block1;
                }
            }
        });
        return Unit.INSTANCE;
    }

    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        class_3222 serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null || serverPlayer.method_37908().field_9236) {
            return Unit.INSTANCE;
        }
        List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
        for (String key : megaKeys) {
            boolean enabled;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
            MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)serverPlayer);
            break;
        }
        return Unit.INSTANCE;
    }

    public static Unit deVolveFlee(BattleFledEvent battleFledEvent) {
        battleFledEvent.getBattle().getPlayers().forEach(serverPlayer -> {
            block0: for (BattlePokemon battlePokemon : battleFledEvent.getBattle().getActor(serverPlayer.method_5667()).getPokemonList()) {
                if (battlePokemon.getOriginalPokemon().getEntity() == null || battlePokemon.getOriginalPokemon().getEntity().method_37908().field_9236) continue;
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
                for (Pokemon pokemon : playerPartyStore) {
                    if (pokemon.getEntity() == null) continue;
                    new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                    new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
                    pokemon.getEntity().method_6016(class_1294.field_5912);
                }
                Pokemon pokemon = battlePokemon.getOriginalPokemon();
                List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                for (String key : megaKeys) {
                    boolean enabled;
                    FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                    FlagSpeciesFeature feature = featureProvider.get(pokemon);
                    if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                    MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)serverPlayer);
                    if (ShowdownConfig.multipleMegas.get().booleanValue()) continue;
                    continue block0;
                }
            }
        });
        return Unit.INSTANCE;
    }

    public static void checkKeldeo(PlayerPartyStore pokemons) {
        for (Pokemon pokemon : pokemons) {
            if (!pokemon.getSpecies().getName().equals("Keldeo")) continue;
            FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("resolute"));
            FlagSpeciesFeature feature = featureProvider.get(pokemon);
            boolean hasMove = false;
            for (Move move : pokemon.getMoveSet().getMoves()) {
                if (!move.getName().equals(Moves.INSTANCE.getByName("secretsword").getName())) continue;
                hasMove = true;
            }
            if (feature == null) continue;
            boolean enabled = featureProvider.get(pokemon).getEnabled();
            if (!enabled) {
                if (!hasMove) continue;
                new FlagSpeciesFeature("resolute", true).apply(pokemon);
                CobbleEventHandler.playEvolveAnimation((class_1309)pokemon.getEntity());
                continue;
            }
            if (hasMove) continue;
            new FlagSpeciesFeature("resolute", false).apply(pokemon);
            CobbleEventHandler.playEvolveAnimation((class_1309)pokemon.getEntity());
        }
    }

    public static Unit battleStarted(BattleStartedPreEvent battleEvent) {
        for (class_3222 player : battleEvent.getBattle().getPlayers()) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            CobbleEventHandler.checkKeldeo(playerPartyStore);
            if (ShowdownConfig.battleMode.get().booleanValue()) {
                for (Pokemon pokemon : playerPartyStore) {
                    List<String> megaKeys = List.of("mega-x", "mega-y", "mega");
                    for (String key : megaKeys) {
                        boolean enabled;
                        FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of(key));
                        FlagSpeciesFeature feature = featureProvider.get(pokemon);
                        if (feature == null || !(enabled = featureProvider.get(pokemon).getEnabled())) continue;
                        MegaLogic.Devolve((class_1309)pokemon.getEntity(), (class_1657)player);
                    }
                }
            }
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasTeraItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof TeraItem)).orElse(false);
            if (hasTeraItemTrinkets && ShowdownConfig.teralization.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
            }
            if ((ShowdownConfig.scuffedMode.get().booleanValue() || ShowdownConfig.battleMode.get().booleanValue() || ShowdownConfig.battleModeOnly.get().booleanValue()) && MegaLogic.Possible(player, true) && (player.getAttached(DataManage.MEGA_DATA) == null || !((Boolean)player.getAttached(DataManage.MEGA_DATA)).booleanValue())) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
            }
            boolean hasZItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_7909() instanceof ZRingItem)).orElse(false);
            if ((player.method_6079().method_31574(ZMoves.Z_RING) || hasZItemTrinkets) && ShowdownConfig.zMoves.get().booleanValue()) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
                continue;
            }
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        class_3222 player = megaEvolutionEvent.getPokemon().getOriginalPokemon().getOwnerPlayer();
        if (player == null) {
            return Unit.INSTANCE;
        }
        MegaLogic.Evolve((class_1309)pokemon.getEntity(), (class_1657)player);
        battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)megaEvolutionEvent.getPokemon()).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
        battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        pokemon.method_6092(new class_1293(class_1294.field_5912, 115, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z_moves");
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(TeraTypeHelper.getGlowColorForType(zMoveUsedEvent.getPokemon().getOriginalPokemon()));
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "terastallized");
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = TeraTypeHelper.getGlowColorForTeraType(terastallizationEvent.getPokemon().getEffectedPokemon().getTeraType());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            if (pk.getSpecies().getName().equals("Ogerpon")) {
                new FlagSpeciesFeature("embody_aspect", true).apply(pk);
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        class_3222 player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        AtomicReference<class_1799> teraOrb = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(TeraMoves.TERA_ORB).forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (!stack.method_7960()) {
                teraOrb.set(stack);
            }
        }));
        if (teraOrb.get() != null) {
            teraOrb.get().method_7974(teraOrb.get().method_7919() + 10);
        }
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        if (!(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        class_1792 correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)correspondingTeraShard));
        int randomValue = new Random().nextInt(101);
        if (randomValue >= 10 && randomValue <= 20) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (randomValue == 33) {
            teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)TeraMoves.STELLAR_TERA_SHARD));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        if (pokemonHealedEvent.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        class_3222 player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        AtomicReference<class_1799> teraOrb = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(TeraMoves.TERA_ORB).forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (!stack.method_7960()) {
                teraOrb.set(stack);
            }
        }));
        if (teraOrb != null) {
            teraOrb.get().method_7974(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        if (pokemon.getSpecies().getName().equals("Aegislash")) {
            if (formeChangeEvent.getFormeName().equals("blade")) {
                new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
            } else if (formeChangeEvent.getFormeName().equals("aegislash")) {
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit fixOgerTera(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        }
        return Unit.INSTANCE;
    }
}

