/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.block;

import com.cobblemon.yajatkaul.mega_showdown.block.custom.CrystalBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.GracideaBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.KeyStoneBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.MaxMushroomBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.PedestalBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.ReassemblyUnitBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.RotomUnit;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.joml.Vector3f;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"mega_showdown");
    public static final DeferredBlock<Block> KEYSTONE_BLOCK = ModBlocks.registerBlock("keystone_block", () -> new KeyStoneBlock(BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEOROID_BLOCK = ModBlocks.registerBlock("mega_meteorid_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_PURPLE).sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_EVO_BLOCK = ModBlocks.registerBlock("mega_evo_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_PURPLE).sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_EVO_BRICK = ModBlocks.registerBlock("mega_evo_brick", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> CHISELED_MEGA_EVO_BRICK = ModBlocks.registerBlock("chiseled_mega_evo_brick", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> CHISELED_MEGA_EVO_BLOCK = ModBlocks.registerBlock("chiseled_mega_evo_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> POLISHED_MEGA_EVO_BLOCK = ModBlocks.registerBlock("polished_mega_evo_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> DEOXYS_METEORITE = BLOCKS.register("deoxys_meteorite", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PINK).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> POWER_SPOT = ModBlocks.registerBlockWithToolTip("power_spot", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).lightLevel(state -> 15).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)){
        public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

        protected VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
            return SHAPE;
        }
    });
    public static final DeferredBlock<Block> MAX_MUSHROOM = BLOCKS.register("max_mushroom", () -> new MaxMushroomBlock(BlockBehaviour.Properties.of().noCollission().sound(SoundType.FLOWERING_AZALEA)));
    public static final DeferredBlock<Block> GRACIDEA_FLOWER = BLOCKS.register("gracidea_flower", GracideaBlock::new);
    public static final DeferredBlock<Block> POTTED_GRACIDEA = BLOCKS.register("potted_gracidea", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, GRACIDEA_FLOWER, BlockBehaviour.Properties.of().noOcclusion().instabreak()));
    public static final DeferredBlock<Block> PEDESTAL = ModBlocks.registerBlock("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(2.0f)));
    public static final DeferredBlock<Block> REASSEMBLY_UNIT = ModBlocks.registerBlock("reassembly_unit", () -> new ReassemblyUnitBlock(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.METAL)));
    public static final DeferredBlock<AmethystClusterBlock> WISHING_STAR_CRYSTAL = ModBlocks.registerBlock("wishing_star_crystal", () -> new CrystalBlock(4.0f, 3.0f, BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.MEDIUM_AMETHYST_BUD).noOcclusion().requiresCorrectToolForDrops().pushReaction(PushReaction.IGNORE).lightLevel(state -> 15)){
        public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);

        protected VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
            return SHAPE;
        }

        public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            for (int i = 0; i < 3; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 0.5;
                double offsetY = (random.nextDouble() - 0.5) * 0.5;
                double offsetZ = (random.nextDouble() - 0.5) * 0.5;
                level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 0.5f), x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    });
    public static final DeferredBlock<AmethystClusterBlock> DORMANT_CRYSTAL = ModBlocks.registerBlock("dormant_crystal", () -> new CrystalBlock(4.0f, 3.0f, BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.MEDIUM_AMETHYST_BUD).noOcclusion().requiresCorrectToolForDrops().pushReaction(PushReaction.IGNORE).lightLevel(state -> 15)){
        private static final VoxelShape SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)11.0);
        private static final VoxelShape SHAPE_DOWN = Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)12.0);
        private static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)4.0, (double)12.0, (double)11.0, (double)11.0, (double)15.0);
        private static final VoxelShape SHAPE_SOUTH = Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)12.0, (double)4.0);
        private static final VoxelShape SHAPE_WEST = Block.box((double)12.0, (double)4.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)4.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0);

        protected VoxelShape getShape(BlockState state, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
            return switch ((Direction)state.getValue((Property)AmethystClusterBlock.FACING)) {
                case Direction.DOWN -> SHAPE_DOWN;
                case Direction.NORTH -> SHAPE_NORTH;
                case Direction.SOUTH -> SHAPE_SOUTH;
                case Direction.WEST -> SHAPE_WEST;
                case Direction.EAST -> SHAPE_EAST;
                default -> SHAPE_UP;
            };
        }
    });
    public static final DeferredBlock<Block> ROTOM_WASHING_MACHINE = BLOCKS.register("rotom_washing_machine", () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), "wash"));
    public static final DeferredBlock<Block> ROTOM_FAN = BLOCKS.register("rotom_fan", () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), "fan"));
    public static final DeferredBlock<Block> ROTOM_MOW = BLOCKS.register("rotom_mow", () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), "mow"));
    public static final DeferredBlock<Block> ROTOM_FRIDGE = BLOCKS.register("rotom_fridge", () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), "frost"));
    public static final DeferredBlock<Block> ROTOM_OVEN = BLOCKS.register("rotom_oven", () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), "heat"));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithToolTip(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItemWithToolTip(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> void registerBlockItemWithToolTip(final String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> list, TooltipFlag arg3) {
                list.add((Component)Component.translatable((String)("tooltip.mega_showdown." + name + ".tooltip")));
                super.appendHoverText(arg, arg2, list, arg3);
            }
        });
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

