/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import com.cobblemon.yajatkaul.mega_showdown.item.configActions.ConfigResults;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ArceusType;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Drives;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Memory;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.ArrayList;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HeldItemChangeFormes {
    public static void genesectChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Genesect")) {
            if (post.getReceived().is(FormeChangeItems.DOUSE_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "water").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.BURN_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "fire").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.CHILL_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "ice").apply(pokemon);
            } else if (post.getReceived().is(FormeChangeItems.SHOCK_DRIVE)) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "electric").apply(pokemon);
            } else if (!(post.getReceived().getItem() instanceof Drives) && post.getReturned().getItem() instanceof Drives) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "none").apply(pokemon);
            }
        }
    }

    public static void silvallyChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Silvally")) {
            Item item = post.getReceived().getItem();
            if (item instanceof Memory) {
                Memory memory = (Memory)item;
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", memory.getType()).apply(pokemon);
            } else if (post.getReturned().getItem() instanceof Memory) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "normal").apply(pokemon);
            }
        }
    }

    public static void arcuesChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        BlockPos entityPos = pokemonEntity.getOnPos();
        if (pokemon.getSpecies().getName().equals("Arceus")) {
            Item item = post.getReceived().getItem();
            if (item instanceof ArceusType) {
                ArceusType plate = (ArceusType)item;
                pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ARCEUS_MULTITYPE.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                LazyLib.Companion.snowStormPartileSpawner((Entity)pokemon.getEntity(), "arceus_" + plate.getType(), "target");
                pokemon.getEntity().getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                pokemon.getEntity().after(3.0f, () -> {
                    new StringSpeciesFeature("multitype", plate.getType()).apply(pokemon);
                    LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
                    pokemon.getEntity().getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                    return Unit.INSTANCE;
                });
            } else if (post.getReturned().getItem() instanceof ArceusType) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "normal").apply(pokemon);
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            }
        }
    }

    public static void originChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (post.getReceived().is(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().is(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Palkia")) {
            if (post.getReceived().is(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().is(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Dialga")) {
            if (post.getReceived().is(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().is(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Post post) {
        if (!MegaShowdownConfig.etermaxForme) {
            return;
        }
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Eternatus")) {
            return;
        }
        if (post.getReceived().is(FormeChangeItems.STAR_CORE)) {
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
            Utils.setTradable(pokemon, false);
        } else if (post.getReturned().is(FormeChangeItems.STAR_CORE)) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
        }
    }

    public static void ogerponChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (post.getReceived().is(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getFIRE());
        } else if (post.getReceived().is(FormeChangeItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getROCK());
        } else if (post.getReceived().is(FormeChangeItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            pokemon.setTeraType(TeraTypes.getWATER());
        } else if (post.getReturned().is(FormeChangeItems.WELLSPRING_MASK) || post.getReturned().is(FormeChangeItems.CORNERSTONE_MASK) || post.getReturned().is(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            try {
                pokemon.setTeraType(TeraTypes.getGRASS());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        }
    }

    public static void primalEvent(HeldItemEvent.Pre pre) {
        ServerPlayer player = pre.getPokemon().getOwnerPlayer();
        Species species = pre.getPokemon().getSpecies();
        if (!species.getName().equals("Kyogre") && !species.getName().equals("Groudon")) {
            return;
        }
        if (!player.hasData(DataManage.PRIMAL_DATA)) {
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
        }
        boolean primalData = (Boolean)player.getData(DataManage.PRIMAL_DATA);
        if (species.getName().equals("Kyogre") && pre.getReceiving().is(MegaStones.BLUE_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.BUBBLE, true);
                player.setData(DataManage.PRIMAL_DATA, (Object)true);
                player.setData(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.primal_limit").withColor(0xFF0000), true);
            }
        } else if (species.getName().equals("Groudon") && pre.getReceiving().is(MegaStones.RED_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.CAMPFIRE_COSY_SMOKE, true);
                player.setData(DataManage.PRIMAL_DATA, (Object)true);
                player.setData(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.primal_limit").withColor(0xFF0000), true);
            }
        } else if (species.getName().equals("Kyogre") && !pre.getReceiving().is(MegaStones.BLUE_ORB) && pre.getReturning().is(MegaStones.BLUE_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.END_ROD, false);
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            player.removeData(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        } else if (species.getName().equals("Groudon") && !pre.getReceiving().is(MegaStones.RED_ORB) && pre.getReturning().is(MegaStones.RED_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), ParticleTypes.END_ROD, false);
            player.setData(DataManage.PRIMAL_DATA, (Object)false);
            player.removeData(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        }
    }

    public static void megaEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getAspects().contains("mega_x") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega")) {
            MegaLogic.Devolve(pokemon, false);
        }
    }

    public static void customEvents(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        for (FormChangeData heldItem : Utils.formChangeRegistry) {
            String[] aspectsDiv;
            String[] nameSpace;
            ResourceLocation customItem;
            Item item;
            ItemStack receivedItem;
            if (heldItem.battle_mode_only().booleanValue()) {
                return;
            }
            if (!heldItem.pokemons().contains(pokemon.getSpecies().getName()) || pokemon.getEntity().isBattling()) continue;
            if (!heldItem.required_aspects().isEmpty()) {
                Object aspects2;
                ArrayList<String> aspectList = new ArrayList<String>();
                for (Object aspects2 : heldItem.required_aspects()) {
                    String[] aspectsDiv2 = ((String)aspects2).split("=");
                    if (aspectsDiv2[1].equals("true") || aspectsDiv2[1].equals("false")) {
                        aspectList.add(((String)aspects2).split("=")[0]);
                        continue;
                    }
                    aspectList.add(((String)aspects2).split("=")[1]);
                }
                boolean allMatch = true;
                aspects2 = aspectList.iterator();
                while (aspects2.hasNext()) {
                    String requiredAspect = (String)aspects2.next();
                    boolean matched = false;
                    for (String pokemonAspect : pokemon.getAspects()) {
                        if (!pokemonAspect.startsWith(requiredAspect)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) {
                    return;
                }
            }
            if ((receivedItem = event.getReceived()).is(item = (Item)BuiltInRegistries.ITEM.get(customItem = ResourceLocation.fromNamespaceAndPath((String)(nameSpace = heldItem.item_id().split(":"))[0], (String)nameSpace[1]))) && (receivedItem.get(DataComponents.CUSTOM_MODEL_DATA) != null && ((CustomModelData)receivedItem.get(DataComponents.CUSTOM_MODEL_DATA)).value() == heldItem.custom_model_data().intValue() || heldItem.custom_model_data() == 0)) {
                if (!heldItem.tradable_form().booleanValue()) {
                    Utils.setTradable(pokemon, false);
                }
                for (String aspects : heldItem.aspects()) {
                    aspectsDiv = aspects.split("=");
                    if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                        new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                        continue;
                    }
                    new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                }
                if (!heldItem.tradable_form().booleanValue()) {
                    Utils.setTradable(pokemon, false);
                }
                ConfigResults.particleEffect((LivingEntity)pokemon.getEntity(), heldItem.effects(), true);
                return;
            }
            if (receivedItem.is(item) && (receivedItem.get(DataComponents.CUSTOM_MODEL_DATA) == null || ((CustomModelData)receivedItem.get(DataComponents.CUSTOM_MODEL_DATA)).value() != heldItem.custom_model_data().intValue()) && heldItem.custom_model_data() != 0) continue;
            if (!heldItem.tradable_form().booleanValue()) {
                Utils.setTradable(pokemon, true);
            }
            for (String aspects : heldItem.default_aspects()) {
                aspectsDiv = aspects.split("=");
                if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                    new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                    continue;
                }
                new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
            }
            if (!heldItem.tradable_form().booleanValue()) {
                Utils.setTradable(pokemon, true);
            }
            ConfigResults.particleEffect((LivingEntity)pokemon.getEntity(), heldItem.effects(), false);
            return;
        }
    }

    public static void crownedEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceived().is(FormeChangeItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                HeldItemChangeFormes.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (event.getReceived().is(FormeChangeItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                HeldItemChangeFormes.crownAnimation((ServerLevel)pokemon.getEntity().level(), pokemon.getEntity().getOnPos(), (LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturned().is(FormeChangeItems.RUSTED_SWORD)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturned().is(FormeChangeItems.RUSTED_SHIELD)) {
                HeldItemChangeFormes.playHeldItemChange((LivingEntity)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            }
        }
    }

    public static void ultraEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.getAspects().contains("ultra") && event.getReturned().is(ZCrystals.ULTRANECROZIUM_Z)) {
            if (!pokemon.getEntity().isBattling()) {
                LazyLib.Companion.cryAnimation((Entity)pokemon.getEntity());
            }
            EventUtils.ultraAnimation((LivingEntity)pokemon.getEntity());
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        }
    }

    private static void playHeldItemChange(LivingEntity context) {
        LazyLib.Companion.cryAnimation((Entity)context);
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void originAnimation(PokemonEntity context, boolean enabled) {
        BlockPos entityPos = context.getOnPos();
        if (context.getPokemon().getSpecies().getName().equals("Giratina")) {
            context.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.GIRATINIA_FORM.get(), SoundSource.PLAYERS, 0.2f, 1.1f);
            LazyLib.Companion.snowStormPartileSpawner((Entity)context, "origin_g_effect", "target");
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(3.8f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                LazyLib.Companion.cryAnimation((Entity)context);
                return Unit.INSTANCE;
            });
        } else {
            context.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ORIGIN_FORM.get(), SoundSource.PLAYERS, 0.2f, 1.1f);
            LazyLib.Companion.snowStormPartileSpawner((Entity)context, "origin_effect", "target");
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(4.0f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                LazyLib.Companion.cryAnimation((Entity)context);
                return Unit.INSTANCE;
            });
        }
    }

    private static void crownAnimation(ServerLevel level, BlockPos pos, LivingEntity context) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
        if (lightning != null) {
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            lightning.setVisualOnly(true);
            level.addFreshEntity((Entity)lightning);
            HeldItemChangeFormes.playHeldItemChange(context);
        }
    }

    private static void primalRevertAnimation(PokemonEntity context, SimpleParticleType particleType, Boolean revert) {
        Level level;
        if (revert.booleanValue()) {
            context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(2.5f, () -> {
                LazyLib.Companion.cryAnimation((Entity)context);
                context.getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        }
        if ((level = context.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)particleType, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

