/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class N_Solarizer
extends Item {
    public N_Solarizer(Item.Properties arg) {
        super(arg);
    }

    public static EntityHitResult getEntityLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        AABB rayTraceBox = new AABB(eyePos, targetPos);
        return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)targetPos, (AABB)rayTraceBox, entity -> !entity.isSpectator() && entity instanceof LivingEntity && entity.isPickable(), (float)0.3f);
    }

    public static void particleEffect(LivingEntity conComponent) {
        Level level = conComponent.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = conComponent.position();
            double entityWidth = conComponent.getBbWidth();
            double entityHeight = conComponent.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ASH, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Entity playerPartyStore2;
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.fail((Object)stack);
        }
        EntityHitResult hitResult = N_Solarizer.getEntityLookingAt(player, 4.5f);
        PokeHandler pokeHandler = (PokeHandler)stack.get(DataManage.POKEMON_STORAGE);
        if (hitResult == null && pokeHandler != null) {
            PlayerPartyStore playerPartyStore2 = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
            playerPartyStore2.add(pokeHandler.getPokemon());
            stack.set(DataManage.POKEMON_STORAGE, null);
            player.setItemInHand(hand, stack);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (hitResult != null && (playerPartyStore2 = hitResult.getEntity()) instanceof PokemonEntity) {
            PokemonEntity pkmn = (PokemonEntity)playerPartyStore2;
            Pokemon context = pkmn.getPokemon();
            if (player.isCrouching()) {
                return InteractionResultHolder.pass((Object)stack);
            }
            PokemonEntity pokemonEntity = context.getEntity();
            if (!(pokemonEntity instanceof PokemonEntity)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            PokemonEntity pk = pokemonEntity;
            Pokemon pokemon = pk.getPokemon();
            if (pokemon.getOwnerPlayer() != player) {
                return InteractionResultHolder.pass((Object)stack);
            }
            PlayerPartyStore playerPartyStore3 = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
            PokeHandler refValue = (PokeHandler)stack.getOrDefault(DataManage.POKEMON_STORAGE, null);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            if (currentValue != null && pokemon.getSpecies().getName().equals("Necrozma")) {
                if (this.checkFused(pokemon)) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.already_fused").withColor(0xFF0000), true);
                    return InteractionResultHolder.pass((Object)stack);
                }
                HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
                map.put(pokemon.getUuid(), currentValue);
                player.setData(DataManage.DATA_MAP, (Object)map);
                pk.setData(DataManage.N_SOLAR_POKEMON, (Object)new PokeHandler(currentValue));
                stack.set(DataManage.POKEMON_STORAGE, null);
                new FlagSpeciesFeature("dusk-fusion", true).apply(pokemon);
                N_Solarizer.particleEffect((LivingEntity)pokemon.getEntity());
                Utils.setTradable(pokemon, false);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.inactive"));
            } else if (currentValue == null && pokemon.getSpecies().getName().equals("Solgaleo")) {
                stack.set(DataManage.POKEMON_STORAGE, (Object)new PokeHandler(pokemon));
                playerPartyStore3.remove(pokemon);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.charged"));
            } else if (pokemon.getSpecies().getName().equals("Necrozma") && this.checkEnabled(pokemon)) {
                boolean enabled;
                FlagSpeciesFeatureProvider featureProvider = new FlagSpeciesFeatureProvider(List.of("ultra"));
                FlagSpeciesFeature feature = featureProvider.get(pokemon);
                if (feature != null && (enabled = featureProvider.get(pokemon).getEnabled())) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                if (!pokemon.getEntity().hasData(DataManage.N_SOLAR_POKEMON)) {
                    HashMap map = (HashMap)player.getData(DataManage.DATA_MAP);
                    Pokemon toAdd = (Pokemon)map.get(pokemon.getUuid());
                    playerPartyStore3.add(toAdd);
                    map.remove(pokemon.getUuid());
                    player.setData(DataManage.DATA_MAP, (Object)map);
                } else {
                    playerPartyStore3.add(((PokeHandler)pokemon.getEntity().getData(DataManage.N_SOLAR_POKEMON)).getPokemon());
                    pk.removeData(DataManage.N_SOLAR_POKEMON);
                }
                new FlagSpeciesFeature("dusk-fusion", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
                N_Solarizer.particleEffect((LivingEntity)pokemon.getEntity());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.n_solarizer.inactive"));
            } else {
                return InteractionResultHolder.pass((Object)stack);
            }
            player.setItemInHand(hand, stack);
            player.getInventory().setChanged();
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean checkEnabled(Pokemon pokemon) {
        return pokemon.getAspects().contains("dusk-fusion");
    }

    private boolean checkFused(Pokemon pokemon) {
        return pokemon.getAspects().contains("dusk-fusion") || pokemon.getAspects().contains("dawn-fusion");
    }
}

