/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FusionData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.HeldItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.KeyItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class MegaCommands {
    public static final List<String> VALID_ITEMS = new ArrayList<String>();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msdopreset").requires(source -> source.method_9259(2))).executes(context -> MegaCommands.executeReset(((class_2168)context.getSource()).method_44023()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> MegaCommands.executeReset(class_2186.method_9315((CommandContext)context, (String)"player"))))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msdresetlock").requires(source -> source.method_9259(0))).executes(context -> MegaCommands.executeResetCommon((class_1657)((class_2168)context.getSource()).method_44023()))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msdresetmega").requires(source -> source.method_9259(0))).executes(context -> MegaCommands.executeResetMega((class_1657)((class_2168)context.getSource()).method_44023()))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msd").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String item : VALID_ITEMS) {
                builder.suggest(item);
            }
            return builder.buildFuture();
        }).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            return MegaCommands.executeGive(player, item, 1);
        })).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return MegaCommands.executeGive(player, item, count);
        })))))));
    }

    private static int executeGive(class_3222 player, String item, int count) {
        for (MegaData pokemon : Utils.megaRegistry) {
            if (!pokemon.msd_id().equals(item)) continue;
            item = pokemon.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid item: " + item)).method_27692(class_124.field_1061), false);
                return 0;
            }
            String[] itemId = item.split(":");
            class_2960 msdItemId = class_2960.method_60655((String)itemId[0], (String)itemId[1]);
            class_1792 msdItem = (class_1792)class_7923.field_41178.method_10223(msdItemId);
            class_1799 stack = new class_1799((class_1935)msdItem, count);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(pokemon.custom_model_data().intValue()));
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)pokemon.item_name()));
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            for (String line : pokemon.item_description()) {
                lore.add(class_2561.method_43471((String)line));
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            player.method_7270(stack);
            player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + item)).method_27692(class_124.field_1060), false);
            return 1;
        }
        for (Record items : Utils.heldItemsRegistry) {
            if (!((HeldItemData)items).msd_id().equals(item)) continue;
            item = ((HeldItemData)items).item_id();
            if (VALID_ITEMS.contains(item)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid item: " + item)).method_27692(class_124.field_1061), false);
                return 0;
            }
            String[] itemId = item.split(":");
            class_2960 msdItemId = class_2960.method_60655((String)itemId[0], (String)itemId[1]);
            class_1792 msdItem = (class_1792)class_7923.field_41178.method_10223(msdItemId);
            class_1799 stack = new class_1799((class_1935)msdItem, count);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(((HeldItemData)items).custom_model_data().intValue()));
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)((HeldItemData)items).item_name()));
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            for (String line : ((HeldItemData)items).item_description()) {
                lore.add(class_2561.method_43471((String)line));
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            player.method_7270(stack);
            player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + item)).method_27692(class_124.field_1060), false);
            return 1;
        }
        for (Record items : Utils.formChangeRegistry) {
            if (!((FormChangeData)items).msd_id().equals(item)) continue;
            item = ((FormChangeData)items).item_id();
            if (VALID_ITEMS.contains(item)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid item: " + item)).method_27692(class_124.field_1061), false);
                return 0;
            }
            String[] itemId = item.split(":");
            class_2960 msdItemId = class_2960.method_60655((String)itemId[0], (String)itemId[1]);
            class_1792 msdItem = (class_1792)class_7923.field_41178.method_10223(msdItemId);
            class_1799 stack = new class_1799((class_1935)msdItem, count);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(((FormChangeData)items).custom_model_data().intValue()));
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)((FormChangeData)items).item_name()));
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            for (String line : ((FormChangeData)items).item_description()) {
                lore.add(class_2561.method_43471((String)line));
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            player.method_7270(stack);
            player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + item)).method_27692(class_124.field_1060), false);
            return 1;
        }
        for (FusionData fusion : Utils.fusionRegistry) {
            if (!fusion.msd_id().equals(item)) continue;
            item = fusion.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid item: " + item)).method_27692(class_124.field_1061), false);
                return 0;
            }
            String[] itemId = item.split(":");
            class_2960 msdItemId = class_2960.method_60655((String)itemId[0], (String)itemId[1]);
            class_1792 msdItem = (class_1792)class_7923.field_41178.method_10223(msdItemId);
            class_1799 stack = new class_1799((class_1935)msdItem, count);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(fusion.custom_model_data()));
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)fusion.item_name()));
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            for (String line : fusion.item_description()) {
                lore.add(class_2561.method_43471((String)line));
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            player.method_7270(stack);
            player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + item)).method_27692(class_124.field_1060), false);
            return 1;
        }
        for (KeyItemData keyItems : Utils.keyItemsRegistry) {
            if (!keyItems.msd_id().equals(item)) continue;
            item = keyItems.item_id();
            if (VALID_ITEMS.contains(item)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid item: " + item)).method_27692(class_124.field_1061), false);
                return 0;
            }
            String[] itemId = item.split(":");
            class_2960 msdItemId = class_2960.method_60655((String)itemId[0], (String)itemId[1]);
            class_1792 msdItem = (class_1792)class_7923.field_41178.method_10223(msdItemId);
            class_1799 stack = new class_1799((class_1935)msdItem, count);
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(keyItems.custom_model_data().intValue()));
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)keyItems.item_name()));
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            for (String line : keyItems.item_description()) {
                lore.add(class_2561.method_43471((String)line));
            }
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            player.method_7270(stack);
            player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + item)).method_27692(class_124.field_1060), false);
            return 1;
        }
        return 0;
    }

    private static int executeReset(class_3222 player) {
        player.removeAttached(DataManage.MEGA_DATA);
        player.removeAttached(DataManage.MEGA_POKEMON);
        player.removeAttached(DataManage.PRIMAL_DATA);
        player.removeAttached(DataManage.PRIMAL_POKEMON);
        player.method_43496((class_2561)class_2561.method_43471((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetCommon(class_1657 player) {
        player.removeAttached(DataManage.MEGA_DATA);
        player.removeAttached(DataManage.MEGA_POKEMON);
        player.removeAttached(DataManage.PRIMAL_DATA);
        player.removeAttached(DataManage.PRIMAL_POKEMON);
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((class_3222)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        for (Pokemon pokemon : storge) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetMega(class_1657 player) {
        player.removeAttached(DataManage.MEGA_DATA);
        player.removeAttached(DataManage.MEGA_POKEMON);
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((class_3222)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        for (Pokemon pokemon : storge) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        return 1;
    }
}

