/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.HeldItemChangeFormes;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.configActions.ConfigResults;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.TeraItem;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraAccessor;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Random;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class CobbleEventHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Post post) {
        if (post.getReturned() == post.getReceived() || post.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.genesectChange(post);
        HeldItemChangeFormes.silvallyChange(post);
        HeldItemChangeFormes.arcuesChange(post);
        HeldItemChangeFormes.ultraEvent(post);
        HeldItemChangeFormes.crownedEvent(post);
        HeldItemChangeFormes.ogerponChange(post);
        HeldItemChangeFormes.eternamaxChange(post);
        HeldItemChangeFormes.originChange(post);
        HeldItemChangeFormes.customEvents(post);
        if (MegaShowdownConfig.battleModeOnly.get().booleanValue()) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.megaEvent(post);
        return Unit.INSTANCE;
    }

    public static Unit onHeldItemChangePrimals(HeldItemEvent.Pre event) {
        if (event.getReceiving() == event.getReturning() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        PokemonEntity pokemonEntity = event.getPokemon().getEntity();
        if (pokemonEntity != null && ((Boolean)pokemonEntity.method_5841().method_12789(PokemonEntity.getEVOLUTION_STARTED())).booleanValue()) {
            event.cancel();
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.primalEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        class_3222 player = post.getPlayer();
        PokeHandler megaPoke = (PokeHandler)player.getAttached(DataManage.MEGA_POKEMON);
        PokeHandler primalPoke = (PokeHandler)player.getAttached(DataManage.PRIMAL_POKEMON);
        if (megaPoke != null && megaPoke.getPokemon() == post.getPokemon()) {
            player.removeAttached(DataManage.MEGA_DATA);
            player.removeAttached(DataManage.MEGA_POKEMON);
        } else if (primalPoke != null && primalPoke.getPokemon() == post.getPokemon()) {
            player.removeAttached(DataManage.PRIMAL_DATA);
            player.removeAttached(DataManage.PRIMAL_POKEMON);
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        battle.dispatchWaitingToFront(5.9f, () -> Unit.INSTANCE);
        if (pokemon.getOwnerPlayer() == null) {
            MegaLogic.NPCEvolve(pokemon.getEntity(), megaEvolutionEvent.getPokemon(), battle);
        } else {
            MegaLogic.Evolve(pokemon.getEntity(), (class_1657)pokemon.getOwnerPlayer(), megaEvolutionEvent.getPokemon(), battle);
        }
        return Unit.INSTANCE;
    }

    public static void updatePackets(PokemonBattle battle, BattlePokemon pk, boolean abilities) {
        Pokemon pokemon = pk.getEntity().getPokemon();
        if (abilities && pk.actor.getType().equals((Object)ActorType.PLAYER)) {
            battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)pk).getEffectedPokemon(), pokemon.getAbility().getTemplate()));
            battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(pokemon));
        }
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (!pk.actor.getType().equals((Object)ActorType.PLAYER) || activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pk.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pk) continue;
            battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pk, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pk, false), false);
        }
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z/z_moves");
        if (pk.getSpecies().getName().equals("Pikachu") && pk.getAspects().contains("partner-cap")) {
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "bond/ash_pikachu");
        }
        pokemon.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            String teamName;
            class_3218 serverLevel = (class_3218)class_19372;
            class_2995 scoreboard = serverLevel.method_14170();
            class_268 team = scoreboard.method_1153(teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8));
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(TeraTypeHelper.getGlowColorForType(pk.getHeldItem$common()));
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        LazyLib.Companion.snowStormPartileSpawner((class_1297)pk.getEntity(), "z_moves", "target");
        zMoveUsedEvent.getBattle().dispatchWaitingToFront(4.0f, () -> Unit.INSTANCE);
        class_2338 entityPos = pokemon.method_24515();
        pokemon.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ZMOVE, class_3419.field_15248, 0.2f, 0.7f);
        pk.getEntity().after(2.5f, () -> {
            LazyLib.Companion.cryAnimation((class_1309)pk.getEntity());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "tera/terastallized");
        class_243 entityPos = pokemon.method_19538();
        pokemon.method_37908().method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, ModSounds.TERASTALLIZATION, class_3419.field_15248, 0.2f, 1.0f);
        if (pk.getSpecies().getName().equals("Terapagos")) {
            new StringSpeciesFeature("tera_form", "stellar").apply(pk);
            CobbleEventHandler.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
        } else if (pk.getSpecies().getName().equals("Ogerpon")) {
            new FlagSpeciesFeature("embody-aspect", true).apply(pk);
            CobbleEventHandler.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
        }
        if (pk instanceof TeraAccessor) {
            TeraAccessor accessor = (TeraAccessor)pk;
            accessor.setTeraEnabled(true);
        }
        pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = TeraTypeHelper.getGlowColorForTeraType(terastallizationEvent.getPokemon().getEffectedPokemon().getTeraType());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        class_3222 player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        TrinketsApi.getTrinketComponent((class_1309)player).flatMap(component -> component.getAllEquipped().stream().map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof TeraItem).findFirst()).ifPresent(teraOrb -> teraOrb.method_7974(teraOrb.method_7919() + 10));
        PokemonBattle battle = terastallizationEvent.getBattle();
        battle.dispatchWaitingToFront(3.0f, () -> {
            LazyLib.Companion.cryAnimation((class_1309)pokemon);
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        if (!MegaShowdownConfig.teralization.get().booleanValue() || MegaShowdownConfig.disableTeraShardDrop.get().booleanValue() || !(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        class_1792 correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)correspondingTeraShard));
        int randomValue = new Random().nextInt(101);
        if (randomValue >= 10 && randomValue <= 20) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (randomValue == 33) {
            teraShardDropEntry.setItem(class_7923.field_41178.method_10221((Object)TeraMoves.STELLAR_TERA_SHARD));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        if (pokemonHealedEvent.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        class_3222 player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        class_1799 teraOrb = TrinketsApi.getTrinketComponent((class_1309)player).flatMap(component -> component.getAllEquipped().stream().map(class_3545::method_15441).filter(stack -> !stack.method_7960() && stack.method_7909() instanceof TeraItem).findFirst()).orElse(null);
        if (teraOrb != null) {
            teraOrb.method_7974(0);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        if (formeChangeEvent.getFormeName().equals("x") || formeChangeEvent.getFormeName().equals("y") || formeChangeEvent.getFormeName().equals("mega") || formeChangeEvent.getFormeName().equals("tera")) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        PokemonBattle battle = formeChangeEvent.getBattle();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        class_2338 entityPos = pokemonEntity.method_24515();
        switch (pokemon.getSpecies().getName()) {
            case "Aegislash": {
                if (formeChangeEvent.getFormeName().equals("blade")) {
                    new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("aegislash")) break;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                break;
            }
            case "Arceus": {
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemonEntity, "arceus_" + formeChangeEvent.getFormeName(), "target");
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ARCEUS_MULTITYPE, class_3419.field_15248, 0.2f, 1.3f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    new StringSpeciesFeature("multitype", formeChangeEvent.getFormeName()).apply(pokemon);
                    LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                    CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Minior": {
                if (formeChangeEvent.getFormeName().equals("meteor")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("meteor_shield", "meteor").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("meteor_shield", "core").apply(pokemon);
                break;
            }
            case "Castform": {
                switch (formeChangeEvent.getFormeName()) {
                    case "sunny": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "sunny").apply(pokemon);
                        break;
                    }
                    case "rainy": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "rainy").apply(pokemon);
                        break;
                    }
                    case "snowy": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "snowy").apply(pokemon);
                    }
                }
                break;
            }
            case "Wishiwashi": {
                if (formeChangeEvent.getFormeName().equals("school")) {
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemonEntity, "wishiwashi_effect", "target");
                        pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 1.3f);
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(5.0f, () -> {
                        new StringSpeciesFeature("schooling_form", "school").apply(pokemon);
                        LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                        CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                        return Unit.INSTANCE;
                    });
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("wishiwashi")) break;
                new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                break;
            }
            case "Mimikyu": {
                if (!formeChangeEvent.getFormeName().equals("busted")) break;
                new StringSpeciesFeature("disguise_form", "busted").apply(pokemon);
                break;
            }
            case "Greninja": {
                if (formeChangeEvent.getFormeName().equals("ash")) {
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 1.3f);
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemonEntity, "battlebond_effect", "root");
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(4.0f, () -> {
                        new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
                        LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                        CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                        return Unit.INSTANCE;
                    });
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_greninja");
                    break;
                }
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_battle_bond");
                break;
            }
            case "Cherrim": {
                if (formeChangeEvent.getFormeName().equals("sunshine")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("blossom_form", "sunshine").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
                break;
            }
            case "Palafin": {
                if (!formeChangeEvent.getFormeName().equals("hero")) break;
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("dolphin_form", "hero").apply(pokemon);
                break;
            }
            case "Morpeko": {
                if (!formeChangeEvent.getFormeName().equals("hangry")) break;
                EventUtils.playFormeChangeAngryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("hunger_mode", "hangry").apply(pokemon);
                break;
            }
            case "Eiscue": {
                if (formeChangeEvent.getFormeName().equals("noice")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("penguin_head", "noice_face").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
                break;
            }
            case "Cramorant": {
                switch (formeChangeEvent.getFormeName()) {
                    case "gulping": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gulping").apply(pokemon);
                        break;
                    }
                    case "cramorant": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "none").apply(pokemon);
                        break;
                    }
                    case "gorging": {
                        EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gorging").apply(pokemon);
                    }
                }
                break;
            }
            case "Darmanitan": {
                if (formeChangeEvent.getFormeName().equals("zen")) {
                    EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                    new StringSpeciesFeature("blazing_mode", "zen").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
                break;
            }
            case "Xerneas": {
                if (!formeChangeEvent.getFormeName().equals("active")) break;
                new StringSpeciesFeature("life_mode", "active").apply(pokemon);
                break;
            }
            case "Terapagos": {
                if (!formeChangeEvent.getFormeName().equals("terastal")) break;
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemonEntity, "terapagos_effect", "target");
                    pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.FORM_CHANGE_BASIC, class_3419.field_15248, 0.2f, 2.1f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(3.9f, () -> {
                    new StringSpeciesFeature("tera_form", "terastal").apply(pokemon);
                    LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                    CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Meloetta": {
                if (formeChangeEvent.getFormeName().equals("pirouette")) {
                    new StringSpeciesFeature("song_forme", "pirouette").apply(pokemon);
                    EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
                    break;
                }
                new StringSpeciesFeature("song_forme", "aria").apply(pokemon);
                break;
            }
            case "Zygarde": {
                if (!formeChangeEvent.getFormeName().equals("complete")) break;
                pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.POWER_CONSTRUCT, class_3419.field_15248, 0.2f, 0.8f);
                battle.dispatchWaitingToFront(4.5f, () -> {
                    LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemonEntity, "power_construct_event", "root");
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    if (pokemon.getAspects().contains("10-percent")) {
                        pokemon.getPersistentData().method_10582("zygarde_form", "10");
                    } else {
                        pokemon.getPersistentData().method_10582("zygarde_form", "50");
                    }
                    new StringSpeciesFeature("percent_cells", "complete").apply(pokemon);
                    LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                    CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Shaymin": {
                if (!formeChangeEvent.getFormeName().equals("shaymin")) break;
                new StringSpeciesFeature("gracidea_forme", "land").apply(pokemon);
                EventUtils.playEvolveAnimation((class_1309)pokemon.getEntity());
            }
        }
        for (FormChangeData forme : Utils.formChangeRegistry) {
            if (!forme.battle_mode_only().booleanValue() || !forme.pokemons().contains(formeChangeEvent.getPokemon().getEffectedPokemon().getSpecies().getName()) || !formeChangeEvent.getFormeName().equals(forme.form_name())) continue;
            for (String aspects : forme.aspects()) {
                String[] aspectsDiv = aspects.split("=");
                if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                    new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                    continue;
                }
                new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
            }
            ConfigResults.particleEffect((class_1309)pokemon.getEntity(), forme.effects(), true);
            break;
        }
        CobbleEventHandler.updatePackets(formeChangeEvent.getBattle(), formeChangeEvent.getPokemon(), false);
        return Unit.INSTANCE;
    }

    public static Unit fixTeraTyping(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            pokemon.setTeraType(TeraTypes.getSTELLAR());
        }
        return Unit.INSTANCE;
    }

    public static Unit pokemonSent(PokemonSentPostEvent pokemonSentPostEvent) {
        class_1937 class_19372;
        TeraAccessor accessor;
        PokemonEntity pokemon = pokemonSentPostEvent.getPokemonEntity();
        Pokemon pk = pokemonSentPostEvent.getPokemon();
        if (pk instanceof TeraAccessor && (accessor = (TeraAccessor)pk).isTeraEnabled() && (class_19372 = pokemon.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8);
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = TeraTypeHelper.getGlowColorForTeraType(pk.getTeraType());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            scoreboard.method_1172(pokemon.method_5667().toString(), team);
        }
        return Unit.INSTANCE;
    }
}

