/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents;

import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FormChangeData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.item.ZCrystals;
import com.cobblemon.yajatkaul.mega_showdown.item.configActions.ConfigResults;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.ArceusType;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Drives;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.Memory;
import com.cobblemon.yajatkaul.mega_showdown.megaevo.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import java.util.ArrayList;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public class HeldItemChangeFormes {
    public static void genesectChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Genesect")) {
            if (post.getReceived().method_31574(FormeChangeItems.DOUSE_DRIVE)) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "water").apply(pokemon);
            } else if (post.getReceived().method_31574(FormeChangeItems.BURN_DRIVE)) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "fire").apply(pokemon);
            } else if (post.getReceived().method_31574(FormeChangeItems.CHILL_DRIVE)) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "ice").apply(pokemon);
            } else if (post.getReceived().method_31574(FormeChangeItems.SHOCK_DRIVE)) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "electric").apply(pokemon);
            } else if (!(post.getReceived().method_7909() instanceof Drives) && post.getReturned().method_7909() instanceof Drives) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("techno_drive", "none").apply(pokemon);
            }
        }
    }

    public static void silvallyChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Silvally")) {
            class_1792 class_17922 = post.getReceived().method_7909();
            if (class_17922 instanceof Memory) {
                Memory memory = (Memory)class_17922;
                HeldItemChangeFormes.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", memory.getType()).apply(pokemon);
            } else if (post.getReturned().method_7909() instanceof Memory) {
                HeldItemChangeFormes.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("rks_memory", "normal").apply(pokemon);
            }
        }
    }

    public static void arcuesChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        class_2338 entityPos = pokemonEntity.method_24515();
        if (pokemon.getSpecies().getName().equals("Arceus")) {
            class_1792 class_17922 = post.getReceived().method_7909();
            if (class_17922 instanceof ArceusType) {
                ArceusType plate = (ArceusType)class_17922;
                pokemonEntity.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ARCEUS_MULTITYPE, class_3419.field_15248, 0.2f, 1.3f);
                LazyLib.Companion.snowStormPartileSpawner((class_1297)pokemon.getEntity(), "arceus_" + plate.getType(), "target");
                pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                pokemon.getEntity().after(3.0f, () -> {
                    new StringSpeciesFeature("multitype", plate.getType()).apply(pokemon);
                    LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
                    pokemon.getEntity().method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                    return Unit.INSTANCE;
                });
            } else if (post.getReturned().method_7909() instanceof ArceusType) {
                HeldItemChangeFormes.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new StringSpeciesFeature("multitype", "normal").apply(pokemon);
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            }
        }
    }

    public static void originChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (pokemon.getSpecies().getName().equals("Giratina")) {
            if (post.getReceived().method_31574(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().method_31574(FormeChangeItems.GRISEOUS_CORE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Palkia")) {
            if (post.getReceived().method_31574(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().method_31574(FormeChangeItems.LUSTROUS_GLOBE)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        } else if (pokemon.getSpecies().getName().equals("Dialga")) {
            if (post.getReceived().method_31574(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), true);
            } else if (post.getReturned().method_31574(FormeChangeItems.ADAMANT_CRYSTAL)) {
                HeldItemChangeFormes.originAnimation(pokemon.getEntity(), false);
            }
        }
    }

    public static void eternamaxChange(HeldItemEvent.Post post) {
        if (!MegaShowdownConfig.etermaxForme.get().booleanValue()) {
            return;
        }
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Eternatus")) {
            return;
        }
        if (post.getReceived().method_31574(FormeChangeItems.STAR_CORE)) {
            LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            new FlagSpeciesFeature("eternamax", true).apply(pokemon);
            Utils.setTradable(pokemon, false);
        } else if (post.getReturned().method_31574(FormeChangeItems.STAR_CORE)) {
            new FlagSpeciesFeature("eternamax", false).apply(pokemon);
            Utils.setTradable(pokemon, true);
        }
    }

    public static void ogerponChange(HeldItemEvent.Post post) {
        Pokemon pokemon = post.getPokemon();
        if (!pokemon.getSpecies().getName().equals("Ogerpon")) {
            return;
        }
        if (post.getReceived().method_31574(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "hearthflame").apply(pokemon);
            LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            try {
                pokemon.setTeraType(TeraTypes.getFIRE());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().method_31574(FormeChangeItems.CORNERSTONE_MASK)) {
            new StringSpeciesFeature("ogre_mask", "cornerstone").apply(pokemon);
            LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            try {
                pokemon.setTeraType(TeraTypes.getROCK());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReceived().method_31574(FormeChangeItems.WELLSPRING_MASK)) {
            new StringSpeciesFeature("ogre_mask", "wellspring").apply(pokemon);
            LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            try {
                pokemon.setTeraType(TeraTypes.getWATER());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        } else if (post.getReturned().method_31574(FormeChangeItems.WELLSPRING_MASK) || post.getReturned().method_31574(FormeChangeItems.CORNERSTONE_MASK) || post.getReturned().method_31574(FormeChangeItems.HEARTHFLAME_MASK)) {
            new StringSpeciesFeature("ogre_mask", "teal").apply(pokemon);
            LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            try {
                pokemon.setTeraType(TeraTypes.getGRASS());
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.info("Sike");
            }
        }
    }

    public static void primalEvent(HeldItemEvent.Pre pre) {
        class_3222 player = pre.getPokemon().getOwnerPlayer();
        Species species = pre.getPokemon().getSpecies();
        if (!species.getName().equals("Kyogre") && !species.getName().equals("Groudon")) {
            return;
        }
        if (!player.hasAttached(DataManage.PRIMAL_DATA)) {
            player.setAttached(DataManage.PRIMAL_DATA, (Object)false);
        }
        boolean primalData = (Boolean)player.getAttached(DataManage.PRIMAL_DATA);
        if (species.getName().equals("Kyogre") && pre.getReceiving().method_31574(MegaStones.BLUE_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals.get().booleanValue()) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), class_2398.field_11247, true);
                player.setAttached(DataManage.PRIMAL_DATA, (Object)true);
                player.setAttached(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.primal_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
        } else if (species.getName().equals("Groudon") && pre.getReceiving().method_31574(MegaStones.RED_ORB) && !pre.getPokemon().getAspects().contains("primal")) {
            if (!primalData || MegaShowdownConfig.multiplePrimals.get().booleanValue()) {
                new StringSpeciesFeature("reversion_state", "primal").apply(pre.getPokemon());
                HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), class_2398.field_17430, true);
                player.setAttached(DataManage.PRIMAL_DATA, (Object)true);
                player.setAttached(DataManage.PRIMAL_POKEMON, (Object)new PokeHandler(pre.getPokemon()));
                Utils.setTradable(pre.getPokemon(), false);
            } else {
                pre.cancel();
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.primal_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
        } else if (species.getName().equals("Kyogre") && !pre.getReceiving().method_31574(MegaStones.BLUE_ORB) && pre.getReturning().method_31574(MegaStones.BLUE_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), class_2398.field_11207, false);
            player.setAttached(DataManage.PRIMAL_DATA, (Object)false);
            player.removeAttached(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        } else if (species.getName().equals("Groudon") && !pre.getReceiving().method_31574(MegaStones.RED_ORB) && pre.getReturning().method_31574(MegaStones.RED_ORB)) {
            new StringSpeciesFeature("reversion_state", "standard").apply(pre.getPokemon());
            HeldItemChangeFormes.primalRevertAnimation(pre.getPokemon().getEntity(), class_2398.field_11207, false);
            player.setAttached(DataManage.PRIMAL_DATA, (Object)false);
            player.removeAttached(DataManage.PRIMAL_POKEMON);
            Utils.setTradable(pre.getPokemon(), true);
        }
    }

    public static void megaEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getAspects().contains("mega_x") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega")) {
            MegaLogic.Devolve(pokemon, true);
        }
    }

    public static void crownedEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Zacian") || pokemon.getSpecies().getName().equals("Zamazenta")) {
            if (event.getReceived().method_31574(FormeChangeItems.RUSTED_SWORD) && pokemon.getSpecies().getName().equals("Zacian")) {
                HeldItemChangeFormes.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (event.getReceived().method_31574(FormeChangeItems.RUSTED_SHIELD) && pokemon.getSpecies().getName().equals("Zamazenta")) {
                HeldItemChangeFormes.crownAnimation((class_3218)pokemon.getEntity().method_37908(), pokemon.getEntity().method_24515(), (class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", true).apply(pokemon);
                Utils.setTradable(pokemon, false);
            } else if (pokemon.getSpecies().getName().equals("Zacian") && event.getReturned().method_31574(FormeChangeItems.RUSTED_SWORD)) {
                HeldItemChangeFormes.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            } else if (pokemon.getSpecies().getName().equals("Zamazenta") && event.getReturned().method_31574(FormeChangeItems.RUSTED_SHIELD)) {
                HeldItemChangeFormes.playHeldItemFormeChange((class_1309)pokemon.getEntity());
                new FlagSpeciesFeature("crowned", false).apply(pokemon);
                Utils.setTradable(pokemon, true);
            }
        }
    }

    public static void ultraEvent(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        if (pokemon.getSpecies().getName().equals("Necrozma") && pokemon.getAspects().contains("ultra") && event.getReturned().method_31574(ZCrystals.ULTRANECROZIUM_Z)) {
            if (!pokemon.getEntity().isBattling()) {
                LazyLib.Companion.cryAnimation((class_1309)pokemon.getEntity());
            }
            EventUtils.ultraAnimation((class_1309)pokemon.getEntity());
            new FlagSpeciesFeature("ultra", false).apply(pokemon);
        }
    }

    public static void customEvents(HeldItemEvent.Post event) {
        Pokemon pokemon = event.getPokemon();
        for (FormChangeData heldItem : Utils.formChangeRegistry) {
            String[] aspectsDiv;
            String[] nameSpace;
            class_2960 customItem;
            class_1792 item;
            class_1799 receivedItem;
            if (heldItem.battle_mode_only().booleanValue()) {
                return;
            }
            if (!heldItem.pokemons().contains(pokemon.getSpecies().getName()) || pokemon.getEntity().isBattling()) continue;
            if (!heldItem.required_aspects().isEmpty()) {
                Object aspects2;
                ArrayList<String> aspectList = new ArrayList<String>();
                for (Object aspects2 : heldItem.required_aspects()) {
                    String[] aspectsDiv2 = ((String)aspects2).split("=");
                    if (aspectsDiv2[1].equals("true") || aspectsDiv2[1].equals("false")) {
                        aspectList.add(((String)aspects2).split("=")[0]);
                        continue;
                    }
                    aspectList.add(((String)aspects2).split("=")[1]);
                }
                boolean allMatch = true;
                aspects2 = aspectList.iterator();
                while (aspects2.hasNext()) {
                    String requiredAspect = (String)aspects2.next();
                    boolean matched = false;
                    for (String pokemonAspect : pokemon.getAspects()) {
                        if (!pokemonAspect.startsWith(requiredAspect)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) {
                    return;
                }
            }
            if ((receivedItem = event.getReceived()).method_31574(item = (class_1792)class_7923.field_41178.method_10223(customItem = class_2960.method_60655((String)(nameSpace = heldItem.item_id().split(":"))[0], (String)nameSpace[1]))) && (receivedItem.method_57824(class_9334.field_49637) != null && ((class_9280)receivedItem.method_57824(class_9334.field_49637)).comp_2382() == heldItem.custom_model_data().intValue() || heldItem.custom_model_data() == 0)) {
                if (!heldItem.tradable_form().booleanValue()) {
                    Utils.setTradable(pokemon, false);
                }
                for (String aspects : heldItem.aspects()) {
                    aspectsDiv = aspects.split("=");
                    if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                        new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                        continue;
                    }
                    new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
                }
                if (!heldItem.tradable_form().booleanValue()) {
                    Utils.setTradable(pokemon, false);
                }
                ConfigResults.particleEffect((class_1309)pokemon.getEntity(), heldItem.effects(), true);
                return;
            }
            if (receivedItem.method_31574(item) && (receivedItem.method_57824(class_9334.field_49637) == null || ((class_9280)receivedItem.method_57824(class_9334.field_49637)).comp_2382() != heldItem.custom_model_data().intValue()) && heldItem.custom_model_data() != 0) continue;
            if (!heldItem.tradable_form().booleanValue()) {
                Utils.setTradable(pokemon, true);
            }
            for (String aspects : heldItem.default_aspects()) {
                aspectsDiv = aspects.split("=");
                if (aspectsDiv[1].equals("true") || aspectsDiv[1].equals("false")) {
                    new FlagSpeciesFeature(aspectsDiv[0], Boolean.parseBoolean(aspectsDiv[1])).apply(pokemon);
                    continue;
                }
                new StringSpeciesFeature(aspectsDiv[0], aspectsDiv[1]).apply(pokemon);
            }
            if (!heldItem.tradable_form().booleanValue()) {
                Utils.setTradable(pokemon, true);
            }
            ConfigResults.particleEffect((class_1309)pokemon.getEntity(), heldItem.effects(), false);
            return;
        }
    }

    private static void playHeldItemFormeChange(class_1309 context) {
        LazyLib.Companion.cryAnimation(context);
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_26980, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static void originAnimation(PokemonEntity context, boolean enabled) {
        class_2338 entityPos = context.method_24515();
        if (context.getPokemon().getSpecies().getName().equals("Giratina")) {
            context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.GIRATINIA_FORM, class_3419.field_15248, 0.2f, 1.1f);
            LazyLib.Companion.snowStormPartileSpawner((class_1297)context, "origin_g_effect", "target");
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(3.8f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                LazyLib.Companion.cryAnimation((class_1309)context);
                return Unit.INSTANCE;
            });
        } else {
            context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.ORIGIN_FORM, class_3419.field_15248, 0.2f, 1.1f);
            LazyLib.Companion.snowStormPartileSpawner((class_1297)context, "origin_effect", "target");
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(4.0f, () -> {
                if (enabled) {
                    new StringSpeciesFeature("orb_forme", "origin").apply(context.getPokemon());
                } else {
                    new StringSpeciesFeature("orb_forme", "altered").apply(context.getPokemon());
                }
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                LazyLib.Companion.cryAnimation((class_1309)context);
                return Unit.INSTANCE;
            });
        }
    }

    private static void crownAnimation(class_3218 level, class_2338 pos, class_1309 context) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)level);
        if (lightning != null) {
            lightning.method_33574(class_243.method_24955((class_2382)pos));
            lightning.method_29498(true);
            level.method_8649((class_1297)lightning);
            HeldItemChangeFormes.playHeldItemFormeChange(context);
        }
    }

    private static void primalRevertAnimation(PokemonEntity context, class_2400 particleType, Boolean revert) {
        class_1937 class_19372;
        if (revert.booleanValue()) {
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
            context.after(2.5f, () -> {
                LazyLib.Companion.cryAnimation((class_1309)context);
                context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                return Unit.INSTANCE;
            });
        }
        if ((class_19372 = context.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            double entityDepth = entityWidth;
            double scaleFactor = 1.2;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_14703, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverWorld.method_14199((class_2394)particleType, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

