/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.megaevo;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.datamanage.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.event.cobbleEvents.CobbleEventHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.MegaStones;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.LazyLib;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public class MegaLogic {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 6000L;

    public static boolean Possible(class_3222 player, Boolean fromBattle) {
        UUID playerId = player.method_5667();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId) && !fromBattle.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.not_so_fast").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return false;
        }
        boolean hasMegaItemTrinkets = TrinketsApi.getTrinketComponent((class_1309)player).map(trinkets -> trinkets.isEquipped(item -> item.method_31573(ModTags.Items.MEGA_BRACELETS))).orElse(false);
        boolean hasOffhandMegaItem = player.method_6079().method_31573(ModTags.Items.MEGA_BRACELETS);
        boolean hasMainhandMegaItem = player.method_6047().method_31573(ModTags.Items.MEGA_BRACELETS);
        if (fromBattle != false ? !hasMegaItemTrinkets && !hasOffhandMegaItem && !hasMainhandMegaItem : !hasMegaItemTrinkets && !hasOffhandMegaItem) {
            return false;
        }
        cooldowns.put(playerId, currentTime + 6000L);
        return true;
    }

    public static void EvoLogic(class_3222 player) {
        class_243 lookVec;
        class_243 endPos;
        if (MegaShowdownConfig.battleModeOnly.get().booleanValue()) {
            return;
        }
        double range = 5.0;
        class_243 startPos = player.method_33571();
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)startPos, (class_243)(endPos = startPos.method_1019((lookVec = player.method_5720()).method_1021(range))), (class_238)player.method_5829().method_18804(lookVec.method_1021(range)).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5863(), (double)(range * range));
        if (entityHit == null) {
            return;
        }
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof PokemonEntity) {
            PokemonEntity pk = (PokemonEntity)class_12972;
            if (pk.method_37908().field_9236) {
                return;
            }
            if (!MegaShowdownConfig.mega.get().booleanValue() || pk.getPokemon().getOwnerPlayer() != player || !Utils.MEGA_POKEMONS.contains(pk.getPokemon().getSpecies().getName()) && !pk.getPokemon().getSpecies().getName().equals("Rayquaza") || !MegaLogic.Possible(player, false)) {
                return;
            }
            boolean isMega = pk.getAspects().stream().anyMatch(aspect -> aspect.startsWith("mega"));
            if (isMega) {
                MegaLogic.Devolve(pk.getPokemon(), false);
            } else {
                MegaLogic.Evolve(pk, (class_1657)player);
            }
        }
    }

    public static void Evolve(PokemonEntity context, class_1657 player) {
        if (context.getPokemon().getOwnerPlayer() != player || player.method_37908().field_9236) {
            return;
        }
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().method_7909());
        if (!player.hasAttached(DataManage.MEGA_DATA)) {
            player.setAttached(DataManage.MEGA_DATA, (Object)false);
        }
        if (((Boolean)player.getAttached(DataManage.MEGA_DATA)).booleanValue() && !MegaShowdownConfig.multipleMegas.get().booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.mega_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (context.isBattling()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.battle_not_allowed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (MegaShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.bond_not_close_mega").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.megaEvolve(context, "mega");
                Utils.setTradable(pokemon, false);
                found = true;
            }
            if (!found) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.rayquaza_no_dragonascent").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                class_2960 paperId = class_2960.method_60655((String)parts[0], (String)parts[1]);
                class_1792 paperItem = (class_1792)class_7923.field_41178.method_10223(paperId);
                if (paperItem == pokemon.heldItem().method_7909() && (pokemon.heldItem().method_57824(class_9334.field_49637) != null && ((class_9280)pokemon.heldItem().method_57824(class_9334.field_49637)).comp_2382() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0]);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1]);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.incorrect_mega_stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            return;
        }
        if (MegaShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.bond_not_close_mega").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x");
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y");
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x");
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y");
                    Utils.setTradable(pokemon, false);
                }
            } else {
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                MegaLogic.megaEvolve(context, "mega");
                Utils.setTradable(pokemon, false);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.incorrect_mega_stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
        }
    }

    public static void Devolve(Pokemon context, Boolean fromBattle) {
        class_3222 player = context.getOwnerPlayer();
        if (player != null && context.getEntity() != null && context.getEntity().isBattling() && !fromBattle.booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.battle_not_allowed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        player.setAttached(DataManage.MEGA_DATA, (Object)false);
        player.removeAttached(DataManage.MEGA_POKEMON);
        if (context.getEntity() != null) {
            MegaLogic.playDevolveAnimation((class_1309)context.getEntity());
        }
        new StringSpeciesFeature("mega_evolution", "none").apply(context);
        Utils.setTradable(context, true);
    }

    public static void megaEvolve(PokemonEntity context, String type) {
        AdvancementHelper.grantAdvancement(context.getPokemon().getOwnerPlayer(), "mega/mega_evolve");
        context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
        LazyLib.Companion.snowStormPartileSpawner((class_1297)context, "mega_evolution", "target");
        class_2338 entityPos = context.method_24515();
        context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.MEGA, class_3419.field_15248, 0.2f, 0.8f);
        context.after(4.8f, () -> {
            LazyLib.Companion.cryAnimation((class_1309)context);
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
            new StringSpeciesFeature("mega_evolution", type).apply(context.getPokemon());
            return Unit.INSTANCE;
        });
    }

    public static void Evolve(PokemonEntity context, class_1657 player, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        if (context.getPokemon().getOwnerPlayer() != player || player.method_37908().field_9236) {
            return;
        }
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().method_7909());
        if (!player.hasAttached(DataManage.MEGA_DATA)) {
            player.setAttached(DataManage.MEGA_DATA, (Object)false);
        }
        if (((Boolean)player.getAttached(DataManage.MEGA_DATA)).booleanValue() && !MegaShowdownConfig.multipleMegas.get().booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.mega_limit").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            if (MegaShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.bond_not_close_mega").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
                found = true;
            }
            if (!found) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.rayquaza_no_dragonascent").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                class_2960 paperId = class_2960.method_60655((String)parts[0], (String)parts[1]);
                class_1792 paperItem = (class_1792)class_7923.field_41178.method_10223(paperId);
                if (paperItem == pokemon.heldItem().method_7909() && (pokemon.heldItem().method_57824(class_9334.field_49637) != null && ((class_9280)pokemon.heldItem().method_57824(class_9334.field_49637)).comp_2382() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0], battlePokemon, pokemonBattle);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1], battlePokemon, pokemonBattle);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.incorrect_mega_stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
                return;
            }
            return;
        }
        if (MegaShowdownConfig.friendshipMode.get().booleanValue() && pokemon.getFriendship() < 200 && !pokemon.getEntity().isBattling()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.bond_not_close_mega").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_X)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_Y)) {
                    player.setAttached(DataManage.MEGA_DATA, (Object)true);
                    player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else {
                player.setAttached(DataManage.MEGA_DATA, (Object)true);
                player.setAttached(DataManage.MEGA_POKEMON, (Object)new PokeHandler(pokemon));
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.incorrect_mega_stone").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFF0000))), true);
        }
    }

    public static void megaEvolve(PokemonEntity context, String type, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        AdvancementHelper.grantAdvancement(context.getPokemon().getOwnerPlayer(), "mega/mega_evolve");
        context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
        LazyLib.Companion.snowStormPartileSpawner((class_1297)context, "mega_evolution", "target");
        class_2338 entityPos = context.method_24515();
        context.method_37908().method_43128(null, (double)entityPos.method_10263(), (double)entityPos.method_10264(), (double)entityPos.method_10260(), ModSounds.MEGA, class_3419.field_15248, 0.2f, 0.8f);
        context.after(4.8f, () -> {
            LazyLib.Companion.cryAnimation((class_1309)context);
            context.method_5841().method_12778(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
            new StringSpeciesFeature("mega_evolution", type).apply(context.getPokemon());
            CobbleEventHandler.updatePackets(pokemonBattle, battlePokemon, true);
            return Unit.INSTANCE;
        });
    }

    public static void playDevolveAnimation(class_1309 context) {
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            double entityWidth = context.method_17681();
            double entityHeight = context.method_17682();
            serverWorld.method_43128(null, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, class_3417.field_19344, class_3419.field_15248, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverWorld.method_14199((class_2394)class_2398.field_11207, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static void NPCEvolve(PokemonEntity context, BattlePokemon battlePokemon, PokemonBattle pokemonBattle) {
        Pokemon pokemon = context.getPokemon();
        String species = Utils.MEGA_STONE_IDS.get(pokemon.heldItem().method_7909());
        if (pokemon.getSpecies().getName().equals("Rayquaza")) {
            for (int i = 0; i < 4; ++i) {
                if (!((Move)pokemon.getMoveSet().getMoves().get(i)).getName().equals("dragonascent")) continue;
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
            }
            return;
        }
        if (species == null) {
            for (MegaData megaPok : Utils.megaRegistry) {
                String[] parts = megaPok.item_id().split(":");
                class_2960 paperId = class_2960.method_60655((String)parts[0], (String)parts[1]);
                class_1792 paperItem = (class_1792)class_7923.field_41178.method_10223(paperId);
                if (paperItem == pokemon.heldItem().method_7909() && (pokemon.heldItem().method_57824(class_9334.field_49637) != null && ((class_9280)pokemon.heldItem().method_57824(class_9334.field_49637)).comp_2382() == megaPok.custom_model_data().intValue() || megaPok.custom_model_data() == 0)) {
                    species = megaPok.pokemon();
                }
                if (species == null) continue;
                if (species.equals(pokemon.getSpecies().getName())) {
                    for (String aspect : megaPok.aspects()) {
                        String[] aspectDiv = aspect.split("=");
                        if (aspectDiv[1].equals("true") || aspectDiv[1].equals("false")) {
                            MegaLogic.megaEvolve(context, aspectDiv[0], battlePokemon, pokemonBattle);
                            continue;
                        }
                        MegaLogic.megaEvolve(context, aspectDiv[1], battlePokemon, pokemonBattle);
                    }
                    Utils.setTradable(pokemon, false);
                    return;
                }
                return;
            }
            return;
        }
        if (species.equals(pokemon.getSpecies().getName())) {
            if (species.equals("Charizard")) {
                if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_X)) {
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.CHARIZARDITE_Y)) {
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else if (species.equals("Mewtwo")) {
                if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_X)) {
                    MegaLogic.megaEvolve(context, "mega_x", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                } else if (pokemon.heldItem().method_31574(MegaStones.MEWTWONITE_Y)) {
                    MegaLogic.megaEvolve(context, "mega_y", battlePokemon, pokemonBattle);
                    Utils.setTradable(pokemon, false);
                }
            } else {
                MegaLogic.megaEvolve(context, "mega", battlePokemon, pokemonBattle);
                Utils.setTradable(pokemon, false);
            }
        }
    }
}

