/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.tag.MegaShowdownTags;
import com.github.yajatkaul.mega_showdown.utils.AccessoriesUtils;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class GimmickTurnCheck {
    public static void check(class_3222 player) {
        GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
        if (PlayerUtils.isBlockNearby(player, MegaShowdownTags.Blocks.POWER_SPOT, MegaShowdownConfig.powerSpotRange) || MegaShowdownConfig.dynamaxAnywhere) {
            if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.DYNAMAX, player)) {
                data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
            } else {
                data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
            }
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"dynamax_band"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.TERASTALLIZATION, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"tera_orb"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.MEGA_EVOLUTION, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"key_stone"));
        }
        if (GimmickTurnCheck.hasGimmick(ShowdownMoveset.Gimmick.Z_POWER, player)) {
            data.getKeyItems().add(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        } else {
            data.getKeyItems().remove(class_2960.method_60655((String)"cobblemon", (String)"z_ring"));
        }
    }

    public static boolean hasGimmick(ShowdownMoveset.Gimmick gimmick, class_3222 player) {
        boolean hasOmniRing = AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.OMNI_RING);
        switch (gimmick) {
            case DYNAMAX: {
                if (!MegaShowdownConfig.dynamax) {
                    return false;
                }
                if (hasOmniRing) {
                    return true;
                }
                return AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.DYNAMAX_BAND);
            }
            case TERASTALLIZATION: {
                if (!MegaShowdownConfig.teralization) {
                    return false;
                }
                if (hasOmniRing) {
                    return true;
                }
                boolean hasTerapagos = PlayerUtils.hasPokemon(player, "Terapagos");
                class_1799 teraOrb = AccessoriesUtils.findFirstItemWithTag((class_1657)player, MegaShowdownTags.Items.TERA_ORB);
                if (teraOrb.method_7960()) {
                    return false;
                }
                if (hasTerapagos) {
                    teraOrb.method_7974(0);
                }
                return teraOrb.method_7919() < 100;
            }
            case Z_POWER: {
                if (!MegaShowdownConfig.zMoves) {
                    return false;
                }
                if (hasOmniRing) {
                    return true;
                }
                return AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.Z_RING);
            }
            case MEGA_EVOLUTION: {
                if (!MegaShowdownConfig.mega) {
                    return false;
                }
                boolean hasMegaAccess = AccessoriesUtils.checkTagInAccessories((class_1309)player, MegaShowdownTags.Items.MEGA_BRACELET);
                return (hasMegaAccess || hasOmniRing) && !MegaGimmick.hasMega(player);
            }
        }
        return false;
    }
}

