/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.status.MegaShowdownStatusEffects;
import com.github.yajatkaul.mega_showdown.utils.DelayedTicker;
import com.github.yajatkaul.mega_showdown.utils.GlowHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1294;

public record MaxGimmick(String pokemonShowdownId, String gmaxMove, AspectSetCodec aspectSetCodec) {
    public static final Codec<MaxGimmick> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("pokemon_showdown_id").forGetter(MaxGimmick::pokemonShowdownId), (App)Codec.STRING.fieldOf("gmax_move").forGetter(MaxGimmick::gmaxMove), (App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(MaxGimmick::aspectSetCodec)).apply((Applicative)instance, MaxGimmick::new));

    public static void scaleDownDynamax(final PokemonEntity pokemonEntity) {
        DelayedTicker.add(new DelayedTicker(MegaShowdownConfig.getDynamaxScaleDuration()){

            @Override
            protected void function() {
                if (!pokemonEntity.method_31481() && pokemonEntity.method_6059(MegaShowdownStatusEffects.DYNAMAX)) {
                    pokemonEntity.method_6016(MegaShowdownStatusEffects.DYNAMAX);
                    pokemonEntity.method_37222(new class_1293(MegaShowdownStatusEffects.DYNAMAX, Integer.MAX_VALUE, this.maxAge - this.age, true, true, true), null);
                } else {
                    this.age = this.maxAge;
                }
                if (this.age == this.maxAge) {
                    pokemonEntity.method_6016(class_1294.field_5912);
                    pokemonEntity.method_6016(MegaShowdownStatusEffects.DYNAMAX);
                }
            }
        });
    }

    public static void scaleUpDynamax(final PokemonEntity pokemonEntity) {
        GlowHandler.applyDynamaxGlow(pokemonEntity);
        DelayedTicker.add(new DelayedTicker(MegaShowdownConfig.getDynamaxScaleDuration()){

            @Override
            protected void function() {
                if (!pokemonEntity.method_31481()) {
                    pokemonEntity.method_6092(new class_1293(MegaShowdownStatusEffects.DYNAMAX, Integer.MAX_VALUE, this.age, true, true, true));
                } else {
                    this.age = this.maxAge;
                }
            }
        });
    }
}

