/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.networking;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.MegaGimmick;
import com.github.yajatkaul.mega_showdown.gimmick.UltraGimmick;
import com.github.yajatkaul.mega_showdown.networking.packets.MegaEvo;
import com.github.yajatkaul.mega_showdown.networking.packets.SecretSwordMoveSwapPacket;
import com.github.yajatkaul.mega_showdown.networking.packets.UltraBurst;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3966;

public class MegaShowdownNetworkHandler {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, MegaEvo.TYPE, MegaEvo.STREAM_CODEC, (buf, context) -> {
            PokemonEntity pokemonEntity;
            class_1657 player = context.getPlayer();
            class_3966 hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
            class_1297 entity = null;
            if (hitResult != null) {
                entity = hitResult.method_17782();
            }
            if (entity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)entity).getPokemon().getOwnerPlayer() == player) {
                MegaGimmick.megaToggle(pokemonEntity);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UltraBurst.TYPE, UltraBurst.STREAM_CODEC, (buf, context) -> {
            PokemonEntity pokemonEntity;
            class_1657 player = context.getPlayer();
            class_3966 hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
            class_1297 entity = null;
            if (hitResult != null) {
                entity = hitResult.method_17782();
            }
            if (entity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)entity).getPokemon().getOwnerPlayer() == player) {
                UltraGimmick.ultraBurst(pokemonEntity.getPokemon());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SecretSwordMoveSwapPacket.TYPE, SecretSwordMoveSwapPacket.STREAM_CODEC, (buf, context) -> {
            class_1657 player = context.getPlayer();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
                    if (!pokemon.getSpecies().getName().equals("Keldeo")) continue;
                    boolean hasSecretSword = pokemon.getMoveSet().getMoves().stream().anyMatch(move -> move.getTemplate().getName().equals("secretsword"));
                    boolean isResolute = pokemon.getAspects().contains("resolute-form");
                    if (!isResolute && hasSecretSword) {
                        Effect.getEffect("mega_showdown:keldeo_effect").applyEffects(pokemon, List.of("sword_form=resolute"), null);
                        continue;
                    }
                    if (!isResolute || hasSecretSword) continue;
                    Effect.getEffect("mega_showdown:keldeo_effect").revertEffects(pokemon, List.of("sword_form=ordinary"), null);
                }
            }
        });
    }
}

