/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.dynamax;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingItem;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaxSoup
extends PokemonSelectingItem {
    public MaxSoup(Item.Properties arg) {
        super(arg);
    }

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(itemStack, pokemon)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        PokemonEntity pokemonEntity = pokemon.getEntity();
        Vec3 pos = ((LivingEntity)Objects.requireNonNullElse(pokemonEntity, player)).position();
        if (pokemon.getGmaxFactor()) {
            pokemon.setGmaxFactor(false);
            if (!player.isCreative()) {
                itemStack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.BOWL));
            }
            player.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 0.4f, 0.5f + (float)Math.random() * 0.5f);
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.gmax_not_possible").withColor(0xFFFFFF), true);
        } else {
            pokemon.setGmaxFactor(true);
            if (!player.isCreative()) {
                itemStack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.BOWL));
            }
            player.level().playSound(null, pos.x, pos.y, pos.z, SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 0.4f, 0.5f + (float)Math.random() * 0.5f);
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.gmax_possible").withColor(0xFFFFFF), true);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getForms().stream().anyMatch(formData -> formData.getLabels().contains("gmax")) && !pokemon.getSpecies().getName().equals("Urshifu");
    }
}

