/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.particles.MinecraftParticle;
import com.github.yajatkaul.mega_showdown.codec.particles.SnowStormParticle;
import com.github.yajatkaul.mega_showdown.datapack.MegaShowdownDatapackRegister;
import com.github.yajatkaul.mega_showdown.utils.AspectUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record Effect(Optional<MinecraftParticle> minecraft, Optional<SnowStormParticle> snowStorm, Optional<Float> battle_pause) {
    public static final Codec<Effect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftParticle.CODEC.optionalFieldOf("minecraft").forGetter(Effect::minecraft), (App)SnowStormParticle.CODEC.optionalFieldOf("snowstorm").forGetter(Effect::snowStorm), (App)Codec.FLOAT.optionalFieldOf("battle_pause").forGetter(Effect::battle_pause)).apply((Applicative)instance, Effect::new));

    public static Effect empty() {
        return new Effect(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Effect getEffect(String effectId) {
        if (effectId == null) {
            return Effect.empty();
        }
        return Objects.requireNonNullElseGet((Effect)MegaShowdownDatapackRegister.EFFECT_REGISTRY.method_10223(class_2960.method_12829((String)effectId)), Effect::empty);
    }

    public static Effect getEffect(class_2960 effectId) {
        if (effectId == null) {
            return Effect.empty();
        }
        return Objects.requireNonNullElseGet((Effect)MegaShowdownDatapackRegister.EFFECT_REGISTRY.method_10223(effectId), Effect::empty);
    }

    public void applyEffects(Pokemon context, List<String> aspects, @Nullable PokemonEntity other) {
        if (context.getEntity() == null) {
            AspectUtils.applyAspects(context, aspects);
            return;
        }
        if (this.snowStorm().isPresent() && this.minecraft().isPresent()) {
            this.minecraft.get().apply(context.getEntity());
            this.snowStorm.get().apply(context.getEntity(), aspects, other);
        } else if (this.minecraft().isPresent()) {
            this.minecraft.get().apply(context.getEntity());
            AspectUtils.applyAspects(context, aspects);
        } else if (this.snowStorm().isPresent()) {
            this.snowStorm.get().apply(context.getEntity(), aspects, other);
        } else {
            AspectUtils.applyAspects(context, aspects);
        }
    }

    public void revertEffects(Pokemon context, List<String> aspects, @Nullable PokemonEntity other) {
        if (context.getEntity() == null) {
            AspectUtils.applyAspects(context, aspects);
            return;
        }
        if (this.snowStorm().isPresent() && this.minecraft().isPresent()) {
            this.minecraft.get().revert(context.getEntity());
            this.snowStorm.get().revert(context.getEntity(), aspects, other);
        } else if (this.minecraft().isPresent()) {
            this.minecraft.get().revert(context.getEntity());
            AspectUtils.applyAspects(context, aspects);
        } else if (this.snowStorm().isPresent()) {
            this.snowStorm.get().revert(context.getEntity(), aspects, other);
        } else {
            AspectUtils.applyAspects(context, aspects);
        }
    }

    public void applyEffectsBattle(Pokemon context, List<String> aspects, @Nullable PokemonEntity other, BattlePokemon battlePokemon) {
        if (context.getEntity() == null) {
            AspectUtils.applyAspects(context, aspects);
            AspectUtils.updatePackets(battlePokemon);
            return;
        }
        if (this.snowStorm().isPresent() && this.minecraft().isPresent()) {
            this.minecraft.get().apply(context.getEntity());
            this.snowStorm.get().applyBattle(context.getEntity(), aspects, other, battlePokemon, this.battle_pause.orElse(Float.valueOf(1.0f)).floatValue());
        } else if (this.minecraft().isPresent()) {
            this.minecraft.get().apply(context.getEntity());
            AspectUtils.applyAspects(context, aspects);
            AspectUtils.updatePackets(battlePokemon);
        } else if (this.snowStorm().isPresent()) {
            this.snowStorm.get().applyBattle(context.getEntity(), aspects, other, battlePokemon, this.battle_pause.orElse(Float.valueOf(1.0f)).floatValue());
        } else {
            AspectUtils.applyAspects(context, aspects);
            AspectUtils.updatePackets(battlePokemon);
        }
    }
}

