/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.gimmick;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.github.yajatkaul.mega_showdown.utils.GlowHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public record MaxGimmick(String pokemonShowdownId, String gmaxMove, AspectSetCodec aspectSetCodec) {
    private static final Map<class_1309, ScalingData> ACTIVE_SCALING_ANIMATIONS = new HashMap<class_1309, ScalingData>();
    private static final int DEFAULT_SCALING_DURATION = 60;
    public static final Codec<MaxGimmick> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("pokemon_showdown_id").forGetter(MaxGimmick::pokemonShowdownId), (App)Codec.STRING.fieldOf("gmax_move").forGetter(MaxGimmick::gmaxMove), (App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(MaxGimmick::aspectSetCodec)).apply((Applicative)instance, MaxGimmick::new));

    public static void startGradualScaling(PokemonEntity entity, float targetScale) {
        if (entity == null) {
            return;
        }
        GlowHandler.applyDynamaxGlow(entity);
        class_1324 scaleAttr = entity.method_5996(class_5134.field_47760);
        if (scaleAttr == null) {
            return;
        }
        float startScale = (float)scaleAttr.method_6201();
        ScalingData scalingData = new ScalingData(startScale, targetScale, 60);
        ACTIVE_SCALING_ANIMATIONS.put((class_1309)entity, scalingData);
    }

    public static void startGradualScalingDown(PokemonEntity entity) {
        if (entity == null) {
            return;
        }
        entity.method_6016(class_1294.field_5912);
        class_1324 scaleAttr = entity.method_5996(class_5134.field_47760);
        if (scaleAttr == null) {
            return;
        }
        float startScale = (float)scaleAttr.method_6201();
        ScalingData scalingData = new ScalingData(startScale, 1.0f, 60);
        ACTIVE_SCALING_ANIMATIONS.put((class_1309)entity, scalingData);
    }

    public static void updateScalingAnimations(MinecraftServer server) {
        if (server == null) {
            return;
        }
        Iterator<Map.Entry<class_1309, ScalingData>> iterator = ACTIVE_SCALING_ANIMATIONS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1309, ScalingData> entry = iterator.next();
            class_1309 entity = entry.getKey();
            ScalingData data = entry.getValue();
            ++data.currentTick;
            if (!entity.method_5805()) {
                iterator.remove();
                continue;
            }
            class_1324 scaleAttr = entity.method_5996(class_5134.field_47760);
            if (scaleAttr != null) {
                float progress = Math.min(1.0f, (float)data.currentTick / (float)data.durationTicks);
                float newScale = data.startScale + (data.targetScale - data.startScale) * progress;
                scaleAttr.method_6192((double)newScale);
            }
            if (data.currentTick < data.durationTicks) continue;
            iterator.remove();
        }
    }

    private static class ScalingData {
        final float startScale;
        final float targetScale;
        final int durationTicks;
        int currentTick;

        public ScalingData(float startScale, float targetScale, int durationTicks) {
            this.startScale = startScale;
            this.targetScale = targetScale;
            this.durationTicks = durationTicks;
            this.currentTick = 0;
        }
    }
}

