/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record FormChangeToggleInteractItem(List<String> form_apply_order, Optional<List<AspectSetCodec>> aspect_conditions, List<List<String>> form_aspect_apply_order, List<String> pokemons, List<ResourceLocation> effects, int consume) {
    public static final Codec<FormChangeToggleInteractItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("form_apply_order").forGetter(FormChangeToggleInteractItem::form_apply_order), (App)AspectSetCodec.CODEC.listOf().optionalFieldOf("aspect_conditions").forGetter(FormChangeToggleInteractItem::aspect_conditions), (App)Codec.STRING.listOf().listOf().fieldOf("form_aspect_apply_order").forGetter(FormChangeToggleInteractItem::form_aspect_apply_order), (App)Codec.STRING.listOf().fieldOf("pokemons").forGetter(FormChangeToggleInteractItem::pokemons), (App)ResourceLocation.CODEC.listOf().fieldOf("effects").forGetter(FormChangeToggleInteractItem::effects), (App)Codec.INT.optionalFieldOf("consume", (Object)0).forGetter(FormChangeToggleInteractItem::consume)).apply((Applicative)instance, FormChangeToggleInteractItem::new));

    public InteractionResult interactLivingEntity(Player player, LivingEntity livingEntity, ItemStack stack) {
        if (player.level().isClientSide || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (livingEntity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (!this.pokemons.contains(pokemon.getSpecies().getName()) || pokemon.getOwnerPlayer() != player || pokemonEntity.isBattling() || pokemonEntity.getTethering() != null || pokemon.getPersistentData().contains("form_changing")) {
                return InteractionResult.PASS;
            }
            int currentIndex = -1;
            for (int i = 0; i < this.form_apply_order.size(); ++i) {
                String form = this.form_apply_order.get(i);
                boolean hasAspect = pokemon.getAspects().stream().anyMatch(aspect -> aspect.equalsIgnoreCase(form));
                if (!hasAspect) continue;
                currentIndex = i;
                break;
            }
            if (currentIndex == -1) {
                return InteractionResult.PASS;
            }
            if (currentIndex + 1 > this.form_apply_order.size() - 1) {
                this.aspect_conditions.ifPresentOrElse(aspect_conditions -> {
                    if (((AspectSetCodec)aspect_conditions.getFirst()).validate_apply(pokemon)) {
                        Effect.getEffect(this.effects.getFirst()).applyEffects(pokemon, this.form_aspect_apply_order.getFirst(), null);
                    }
                }, () -> Effect.getEffect(this.effects.getFirst()).applyEffects(pokemon, this.form_aspect_apply_order.getFirst(), null));
            } else {
                int finalCurrentIndex = currentIndex;
                this.aspect_conditions.ifPresentOrElse(aspect_conditions -> {
                    if (((AspectSetCodec)aspect_conditions.get(finalCurrentIndex + 1)).validate_apply(pokemon)) {
                        Effect.getEffect(this.effects.get(finalCurrentIndex + 1)).applyEffects(pokemon, this.form_aspect_apply_order.get(finalCurrentIndex + 1), null);
                    }
                }, () -> Effect.getEffect(this.effects.get(finalCurrentIndex + 1)).applyEffects(pokemon, this.form_aspect_apply_order.get(finalCurrentIndex + 1), null));
            }
            stack.consume(this.consume, livingEntity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

